<?php
// settings.php - Настройки админ-панели
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit();
}

// Обработка POST-запросов для обновления файлов
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    $action = $_POST['action'] ?? '';

    if ($action === 'update_procent') {
        $procent = (int)($_POST['procent'] ?? 10);
        $data = ['procent' => $procent];
        file_put_contents('procent.json', json_encode($data, JSON_PRETTY_PRINT));
        echo json_encode(['success' => true, 'message' => 'Процент обновлен']);
        exit();
    }

    if ($action === 'update_chats') {
        $zayavki = (int)($_POST['zayavki'] ?? 0);
        $support = (int)($_POST['support'] ?? 0);
        $data = [
            'zayavki' => $zayavki,
            'support' => $support
        ];
        file_put_contents('chats.json', json_encode($data, JSON_PRETTY_PRINT));
        echo json_encode(['success' => true, 'message' => 'Чаты обновлены']);
        exit();
    }

    if ($action === 'update_functions') {
        $simcard = filter_var($_POST['simcard'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $qrcode = filter_var($_POST['qrcode'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $bankcard = filter_var($_POST['bankcard'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $vivod = filter_var($_POST['vivod'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $data = [
            'simcard' => $simcard,
            'qrcode' => $qrcode,
            'bankcard' => $bankcard,
            'vivod' => $vivod
        ];
        file_put_contents('function.json', json_encode($data, JSON_PRETTY_PRINT));
        echo json_encode(['success' => true, 'message' => 'Настройки функций обновлены']);
        exit();
    }

    echo json_encode(['success' => false, 'message' => 'Неизвестное действие']);
    exit();
}

// Загрузка текущих значений
$procent_data = json_decode(file_get_contents('procent.json'), true) ?? ['procent' => 10];
$current_procent = $procent_data['procent'] ?? 10;

$chats_data = json_decode(file_get_contents('chats.json'), true) ?? ['zayavki' => 0, 'support' => 0];
$current_zayavki = $chats_data['zayavki'] ?? 0;
$current_support = $chats_data['support'] ?? 0;

$functions_data = json_decode(file_get_contents('function.json'), true) ?? [
    'simcard' => true,
    'qrcode' => true,
    'bankcard' => true,
    'vivod' => true
];
$current_simcard = $functions_data['simcard'] ?? true;
$current_qrcode = $functions_data['qrcode'] ?? true;
$current_bankcard = $functions_data['bankcard'] ?? true;
$current_vivod = $functions_data['vivod'] ?? true;
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Настройки - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-slate-50 to-blue-50 min-h-screen flex">
    <!-- Sidebar -->
    <?php include 'admin_sidebar.php'; ?>

    <!-- Main Content -->
    <div class="flex-1 lg:ml-64 p-6">
        <div class="max-w-md mx-auto">
            <h1 class="text-3xl font-bold text-gray-800 mb-8 text-center">Настройки</h1>

            <!-- Процент -->
            <div class="bg-white rounded-2xl shadow-lg p-6 mb-6">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">Комиссия (%)</h2>
                <form id="procent-form">
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Текущий процент:</label>
                        <input type="number" id="procent-input" value="<?php echo $current_procent; ?>" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500" min="0" max="100">
                    </div>
                    <button type="submit" class="w-full bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600 transition">Сохранить</button>
                </form>
            </div>

            <!-- Чаты -->
            <div class="bg-white rounded-2xl shadow-lg p-6 mb-6">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">Чаты</h2>
                <form id="chats-form">
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Чат заявок (ID):</label>
                        <input type="number" id="zayavki-input" value="<?php echo $current_zayavki; ?>" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Чат поддержки (ID):</label>
                        <input type="number" id="support-input" value="<?php echo $current_support; ?>" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                    </div>
                    <button type="submit" class="w-full bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600 transition">Сохранить</button>
                </form>
            </div>

            <!-- Функции (переключатели) -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">Функции</h2>
                <form id="functions-form">
                    <div class="mb-4">
                        <label class="flex items-center justify-between text-sm font-medium text-gray-700">
                            <span>СимКарта</span>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" id="simcard-toggle" <?php echo $current_simcard ? 'checked' : ''; ?> class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                            </label>
                        </label>
                        <input type="hidden" name="simcard" value="<?php echo $current_simcard ? 'true' : 'false'; ?>">
                    </div>
                    <div class="mb-4">
                        <label class="flex items-center justify-between text-sm font-medium text-gray-700">
                            <span>QrCode</span>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" id="qrcode-toggle" <?php echo $current_qrcode ? 'checked' : ''; ?> class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                            </label>
                        </label>
                        <input type="hidden" name="qrcode" value="<?php echo $current_qrcode ? 'true' : 'false'; ?>">
                    </div>
                    <div class="mb-4">
                        <label class="flex items-center justify-between text-sm font-medium text-gray-700">
                            <span>Банковская карта</span>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" id="bankcard-toggle" <?php echo $current_bankcard ? 'checked' : ''; ?> class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                            </label>
                        </label>
                        <input type="hidden" name="bankcard" value="<?php echo $current_bankcard ? 'true' : 'false'; ?>">
                    </div>
                    <div class="mb-6">
                        <label class="flex items-center justify-between text-sm font-medium text-gray-700">
                            <span>Вывод средств</span>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" id="vivod-toggle" <?php echo $current_vivod ? 'checked' : ''; ?> class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                            </label>
                        </label>
                        <input type="hidden" name="vivod" value="<?php echo $current_vivod ? 'true' : 'false'; ?>">
                    </div>
                    <button type="submit" class="w-full bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600 transition">Сохранить</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Обработка форм
        document.getElementById('procent-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            const procent = document.getElementById('procent-input').value;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ action: 'update_procent', procent })
                });
                const data = await response.json();
                if (data.success) {
                    alert('Процент сохранен!');
                } else {
                    alert('Ошибка: ' + data.message);
                }
            } catch (error) {
                alert('Ошибка сохранения');
            }
        });

        document.getElementById('chats-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            const zayavki = document.getElementById('zayavki-input').value;
            const support = document.getElementById('support-input').value;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ action: 'update_chats', zayavki, support })
                });
                const data = await response.json();
                if (data.success) {
                    alert('Чаты сохранены!');
                } else {
                    alert('Ошибка: ' + data.message);
                }
            } catch (error) {
                alert('Ошибка сохранения');
            }
        });

        // Обработка формы функций
        document.getElementById('functions-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            const simcard = document.getElementById('simcard-toggle').checked;
            const qrcode = document.getElementById('qrcode-toggle').checked;
            const bankcard = document.getElementById('bankcard-toggle').checked;
            const vivod = document.getElementById('vivod-toggle').checked;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ action: 'update_functions', simcard: simcard ? 'true' : 'false', qrcode: qrcode ? 'true' : 'false', bankcard: bankcard ? 'true' : 'false', vivod: vivod ? 'true' : 'false' })
                });
                const data = await response.json();
                if (data.success) {
                    alert('Настройки функций сохранены!');
                } else {
                    alert('Ошибка: ' + data.message);
                }
            } catch (error) {
                alert('Ошибка сохранения');
            }
        });
    </script>
</body>
</html>