<?php
// Если это POST запрос - обрабатываем отзыв
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['user_id']) || !isset($data['text']) || !isset($data['reyting'])) {
        echo json_encode(['success' => false, 'message' => 'Не все данные переданы']);
        exit;
    }
    
    $userId = $data['user_id'];
    $text = $data['text'];
    $reyting = $data['reyting'];
    
    $baseDir = __DIR__ . '/otziv';
    $userDir = $baseDir . '/' . $userId;
    
    if (!file_exists($userDir)) {
        mkdir($userDir, 0755, true);
    }
    
    $fileNumber = 1;
    while (file_exists($userDir . '/' . $userId . '_' . $fileNumber . '.json')) {
        $fileNumber++;
    }
    
    $fileName = $userId . '_' . $fileNumber . '.json';
    $filePath = $userDir . '/' . $fileName;
    
    $reviewData = [
        'text' => $text,
        'reyting' => $reyting,
        'timestamp' => date('Y-m-d H:i:s')
    ];
    
    if (file_put_contents($filePath, json_encode($reviewData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
        echo json_encode(['success' => true, 'file_name' => $fileName]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Ошибка сохранения']);
    }
    exit;
}

// Если это GET запрос - показываем HTML
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Оставить отзыв</title>
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @keyframes slideUp { from { opacity: 0; transform: translateY(30px); } to { opacity: 1; transform: translateY(0); } }
        @keyframes scaleIn { 0% { transform: scale(0); } 50% { transform: scale(1.1); } 100% { transform: scale(1); } }
        .animate-slide { animation: slideUp 0.4s ease-out; }
        .animate-scale { animation: scaleIn 0.5s ease-out; }
        .star { transition: all 0.2s; }
        .star:hover, .star.active { color: #ffd700; transform: scale(1.1); }
    </style>
</head>
<body class="bg-gradient-to-br from-indigo-500 to-purple-600 min-h-screen flex items-center justify-center p-5">
    <div id="app"></div>

    <script>
        const tg = window.Telegram.WebApp;
        tg.expand();
        tg.ready();

        const app = document.getElementById('app');
        const userId = tg.initDataUnsafe?.user?.id || 'test_user';
        let selectedRating = 0;

        function showReviewForm() {
            app.innerHTML = `
                <div class="bg-white rounded-3xl p-8 max-w-md w-full shadow-2xl animate-slide">
                    <h1 class="text-2xl font-bold text-gray-800 text-center mb-2">Ваше мнение важно!</h1>
                    <p class="text-sm text-gray-500 text-center mb-6">Поделитесь своими впечатлениями</p>
                    
                    <textarea id="reviewText" placeholder="Введите свой отзыв..." 
                        class="w-full min-h-32 p-4 border-2 border-gray-200 rounded-xl text-base resize-y mb-6 focus:outline-none focus:border-indigo-500 transition-colors"></textarea>
                    
                    <div id="stars" class="flex justify-center gap-3 mb-8">
                        ${[1,2,3,4,5].map(n => `<span class="star text-4xl cursor-pointer text-gray-300 select-none" data-rating="${n}">★</span>`).join('')}
                    </div>
                    
                    <button id="submitBtn" disabled class="w-full py-4 bg-gradient-to-r from-indigo-500 to-purple-600 text-white rounded-xl text-lg font-semibold disabled:bg-gray-300 disabled:cursor-not-allowed hover:shadow-lg transition-all">
                        Опубликовать отзыв
                    </button>
                </div>
            `;

            const stars = document.querySelectorAll('.star');
            const btn = document.getElementById('submitBtn');
            const txt = document.getElementById('reviewText');

            stars.forEach(s => s.onclick = () => {
                selectedRating = parseInt(s.dataset.rating);
                stars.forEach((st, i) => st.classList.toggle('active', i < selectedRating));
                checkValid();
            });

            const checkValid = () => btn.disabled = !(selectedRating > 0 && txt.value.trim());
            txt.oninput = checkValid;
            btn.onclick = submitReview;
        }

        async function submitReview() {
            const btn = document.getElementById('submitBtn');
            const txt = document.getElementById('reviewText').value;
            
            btn.disabled = true;
            btn.textContent = 'Отправка...';

            try {
                const res = await fetch('review.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ user_id: userId, text: txt, reyting: selectedRating })
                });
                
                const result = await res.json();
                if (result.success) showSuccess();
                else throw new Error(result.message);
            } catch (e) {
                alert('Ошибка отправки. Попробуйте снова.');
                btn.disabled = false;
                btn.textContent = 'Опубликовать отзыв';
            }
        }

        function showSuccess() {
            app.innerHTML = `
                <div class="bg-white rounded-3xl p-8 max-w-md w-full shadow-2xl text-center animate-slide">
                    <div class="text-7xl mb-6 animate-scale">✓</div>
                    <h2 class="text-3xl font-bold text-green-600 mb-3">Спасибо за ваш отзыв!</h2>
                    <p class="text-gray-500 mb-8">Ваше мнение очень важно для нас</p>
                    <button onclick="tg.close()" class="w-full py-4 bg-green-600 text-white rounded-xl text-lg font-semibold hover:bg-green-700 hover:shadow-lg transition-all">
                        Закрыть окно
                    </button>
                </div>
            `;
        }

        showReviewForm();
    </script>
</body>
</html>