<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit();
}

// Подключение к базе данных SQLite
$db = new PDO('sqlite:data.db');
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Получение списка заявок из таблицы payments
$stmt = $db->prepare("SELECT * FROM payments ORDER BY date_time DESC");
$stmt->execute();
$requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Заявки - Админ-панель</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        pastel: {
                            pink: '#fce7f3',
                            blue: '#dbeafe',
                            green: '#dcfce7',
                            yellow: '#fef3c7',
                            purple: '#ede9fe',
                        },
                        gradient: {
                            from: '#f8fafc',
                            to: '#f1f5f9',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        /* Кастомные стили для пастельного градиента и мягких эффектов */
        .pastel-bg {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }
        .card-glass {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .gradient-card {
            background: linear-gradient(135deg, #fef3c7 0%, #dbeafe 100%);
        }
        .hover-lift {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .hover-lift:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .table-row-hover {
            transition: background-color 0.2s ease;
        }
        .table-row-hover:hover {
            background-color: rgba(254, 243, 199, 0.5);
        }
        /* Мобильные стили для таблицы */
        @media (max-width: 768px) {
            .table-container {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
            .table th, .table td {
                min-width: 120px;
                padding: 0.75rem 0.5rem;
                font-size: 0.875rem;
            }
            .btn-mobile {
                padding: 0.5rem 0.75rem;
                font-size: 0.75rem;
            }
        }
    </style>
</head>
<body class="min-h-screen font-sans antialiased pastel-bg">
    <?php include 'admin_sidebar.php'; ?>
    
    <div class="lg:ml-64 p-4 lg:p-8 min-h-screen">
        <!-- Мобильная кнопка меню (toggle) -->
        <button id="menu-toggle" class="lg:hidden fixed top-4 left-4 z-50 p-2 bg-white rounded-xl shadow-md text-gray-600 hover:text-gray-800 transition-colors">
            <span class="text-2xl">☰</span>
        </button>
        
        <!-- Header Card -->
        <div class="card-glass rounded-3xl p-4 lg:p-8 mb-6 lg:mb-8 hover-lift relative">
            <div class="flex justify-between items-center flex-col lg:flex-row lg:gap-4">
                <div class="flex items-center mb-4 lg:mb-0">
                    <div class="w-10 h-10 lg:w-12 lg:h-12 bg-gradient-to-br from-yellow-200 to-green-200 rounded-xl lg:rounded-2xl flex items-center justify-center mr-3 lg:mr-4">
                        <span class="text-lg lg:text-xl">📋</span>
                    </div>
                    <div>
                        <h1 class="text-2xl lg:text-3xl font-bold text-gray-800">Заявки</h1>
                        <p class="text-gray-600 mt-1 text-sm lg:text-base">Список заявок (СимКарта / QR Code / Карта)</p>
                    </div>
                </div>
                <div class="relative max-w-full lg:max-w-md w-full">
                    <input type="text" id="searchInput" class="w-full pl-10 lg:pl-12 pr-4 py-2 lg:py-3 rounded-xl lg:rounded-2xl bg-white border border-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-200 focus:border-transparent transition-all shadow-sm text-sm" placeholder="Поиск по ID или phone...">
                    <span class="absolute left-3 top-2.5 lg:left-4 lg:top-3.5 text-gray-400 text-sm">🔍</span>
                </div>
            </div>
        </div>
        
        <!-- Table Card -->
        <div class="card-glass rounded-3xl overflow-hidden hover-lift table-container">
            <div class="px-4 lg:px-8 py-4 lg:py-6 border-b border-gray-200">
                <h2 class="text-base lg:text-lg font-semibold text-gray-700">Все заявки</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full table-auto">
                    <thead class="bg-white/50">
                        <tr>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">User ID</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">ID Заявки</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Статус</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Менеджер</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Дата/Время</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Тип (СимКарта / QR Code / Карта)</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Сумма (+10%)</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php if (empty($requests)): ?>
                            <tr>
                                <td colspan="7" class="px-4 lg:px-8 py-16 text-center text-gray-500">
                                    <div class="flex flex-col items-center">
                                        <div class="text-5xl lg:text-6xl mb-4 opacity-30">📋</div>
                                        <p class="text-base lg:text-lg font-medium">Заявки не найдены</p>
                                        <p class="text-sm mt-1">Заявки появятся после создания</p>
                                    </div>
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($requests as $request): ?>
                                <?php 
                                    $summa_plus_10 = $request['summa'] * 1.1;
                                    $is_simkarta = !empty($request['phone']);
                                    $is_qr_code = empty($request['phone']) && !empty($request['qr_code']) && !empty($request['link']);
                                    $is_card = empty($request['phone']) && empty($request['qr_code']) && empty($request['link']) && !empty($request['card_number']) && !empty($request['card_date']);
                                    $status_class = '';
                                    $status_text = $request['status'];
                                    if ($request['status'] === 'load') {
                                        $status_class = 'bg-gray-100 text-gray-800';
                                        $status_text = 'Не обработана';
                                    } elseif ($request['status'] === 'true') {
                                        $status_class = 'bg-green-100 text-green-800';
                                        $status_text = 'Подтверждена';
                                    } elseif ($request['status'] === 'false') {
                                        $status_class = 'bg-red-100 text-red-800';
                                        $status_text = 'Отклонена';
                                    }
                                ?>
                                <tr class="table-row-hover">
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <span class="inline-flex px-2 lg:px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo htmlspecialchars($request['user_id']); ?></span>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <div class="text-xs lg:text-sm font-medium text-gray-900">#<?php echo htmlspecialchars($request['id_zayavki']); ?></div>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo $status_class; ?>">
                                            <?php echo $status_text; ?>
                                        </span>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <div class="text-xs lg:text-sm text-gray-600"><?php echo htmlspecialchars($request['manager'] ?: 'Не назначен'); ?></div>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <div class="text-xs lg:text-sm text-gray-600"><?php echo htmlspecialchars($request['date_time']); ?></div>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <?php if ($is_simkarta): ?>
                                            <div class="text-xs lg:text-sm font-medium text-blue-700">
                                                <?php echo htmlspecialchars($request['phone']); ?> (СимКарта)
                                            </div>
                                        <?php elseif ($is_qr_code): ?>
                                            <div class="text-xs lg:text-sm font-medium text-purple-700 flex items-center space-x-2">
                                                <span>QR Code</span>
                                                <a href="<?php echo htmlspecialchars($request['qr_code']); ?>" target="_blank" class="text-xs bg-purple-100 text-purple-700 px-2 py-1 rounded-full hover:bg-purple-200 transition-colors">
                                                    Посмотреть
                                                </a>
                                            </div>
                                            <div class="text-xs text-gray-500 mt-1">
                                                Ссылка: <a href="<?php echo htmlspecialchars($request['link']); ?>" target="_blank" class="text-blue-600 hover:underline"><?php echo htmlspecialchars($request['link']); ?></a>
                                            </div>
                                        <?php elseif ($is_card): ?>
                                            <div class="text-xs lg:text-sm font-medium text-green-700">
                                                <?php echo htmlspecialchars($request['card_number']); ?> / <?php echo htmlspecialchars($request['card_date']); ?> (Карта)
                                            </div>
                                        <?php else: ?>
                                            <div class="text-xs lg:text-sm text-gray-400">—</div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <div class="text-xs lg:text-sm font-medium text-gray-900"><?php echo number_format($summa_plus_10, 2); ?> ₽</div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        // JS для мобильного toggle (из sidebar)
        const menuToggle = document.getElementById('menu-toggle');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        if (menuToggle) {
            menuToggle.addEventListener('click', () => {
                sidebar.classList.toggle('-translate-x-full');
                if (overlay) overlay.classList.toggle('hidden');
            });
        }

        if (overlay) {
            overlay.addEventListener('click', () => {
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            });
        }

        // Закрыть на esc
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') {
                sidebar.classList.add('-translate-x-full');
                if (overlay) overlay.classList.add('hidden');
            }
        });

        // Простой поиск по таблице (по ID заявки или phone)
        const searchInput = document.getElementById('searchInput');
        const rows = document.querySelectorAll('tbody tr');

        searchInput.addEventListener('keyup', function() {
            const query = this.value.toLowerCase();
            rows.forEach(row => {
                if (row.cells.length > 0) {
                    const idZayavki = row.cells[1]?.textContent.toLowerCase() || '';
                    const phone = row.cells[5]?.textContent.toLowerCase() || '';
                    if (idZayavki.includes(query) || phone.includes(query)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                }
            });
        });
    </script>
</body>
</html>