<?php
// managers_webapp.php - Telegram WebApp для проверки менеджера

// Обработка POST-запроса для проверки user_id
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    
    $input = json_decode(file_get_contents('php://input'), true);
    $user_id = (int)($input['user_id'] ?? 0);
    
    if ($user_id <= 0) {
        echo json_encode(['success' => false, 'message' => 'Неверный user_id']);
        exit();
    }
    
    try {
        // Подключение к базе данных SQLite
        $db = new PDO('sqlite:data.db');
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Проверка наличия user_id в таблице manager
        $stmt = $db->prepare("SELECT user_id FROM manager WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $exists = $stmt->fetch() !== false;
        
        if ($exists) {
            echo json_encode(['success' => true, 'message' => 'Успешно']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Вам отказано в доступе']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Ошибка базы данных']);
    }
    exit();
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Managers WebApp</title>
    <!-- Telegram WebApp Script -->
    <script src="https://telegram.org/js/telegram-web-app.js?59"></script>
    <!-- Tailwind CSS CDN для стиля -->
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); }
        .menu-button {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .menu-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center font-sans antialiased">
    <div id="app" class="w-full max-w-md p-6">
        <div id="loading" class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-500 mx-auto mb-4"></div>
            <p class="text-gray-600">Проверка доступа...</p>
        </div>
        
        <div id="success" class="hidden text-center">
            <h1 class="text-3xl font-bold text-gray-800 mb-8">Панель менеджера</h1>
            <div class="space-y-4">
                <a href="manager_zayavki.php" class="block menu-button bg-gradient-to-r from-purple-500 to-pink-500 text-white px-6 py-3 rounded-xl font-medium text-lg text-center no-underline">
                    📋 Заявки
                </a>
                <a href="manager_my_zayavki.php" class="block menu-button bg-gradient-to-r from-blue-500 to-purple-500 text-white px-6 py-3 rounded-xl font-medium text-lg text-center no-underline">
                    📊 Моя статистика
                </a>
                <button class="w-full menu-button bg-gradient-to-r from-gray-500 to-gray-600 text-white px-6 py-3 rounded-xl font-medium text-lg" onclick="closeApp()">
                    ❌ Закрыть
                </button>
            </div>
        </div>
        
        <div id="error" class="hidden text-center">
            <div class="text-6xl mb-4">❌</div>
            <h1 class="text-2xl font-bold text-red-600 mb-2" id="error-title">Вам отказано в доступе</h1>
            <p class="text-gray-600" id="error-message">Обратитесь к администратору.</p>
        </div>
        
        <div id="telegram-only" class="hidden text-center">
            <div class="text-6xl mb-4">📱</div>
            <h1 class="text-2xl font-bold text-gray-600 mb-2">Приложение работает только в Telegram</h1>
            <p class="text-gray-500">Откройте через бота в Telegram.</p>
        </div>
    </div>

    <script>
        // Инициализация Telegram WebApp
        let tg = window.Telegram?.WebApp;
        if (tg) {
            tg.ready();
            tg.expand();
        }

        // Функция проверки доступа
        async function checkAccess() {
            if (!tg) {
                showTelegramOnly();
                return;
            }

            const user = tg.initDataUnsafe?.user;
            if (!user || !user.id) {
                showError('Не удалось получить данные пользователя');
                return;
            }

            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ user_id: user.id })
                });
                const data = await response.json();

                if (data.success) {
                    showSuccess(data.message);
                } else {
                    showError(data.message);
                }
            } catch (error) {
                showError('Ошибка проверки: ' + error.message);
            }
        }

        function showSuccess(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('success').classList.remove('hidden');
        }

        function showError(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('error').classList.remove('hidden');
            document.getElementById('error-title').textContent = 'Вам отказано в доступе';
            document.getElementById('error-message').textContent = message;
            tg?.showAlert(message);
        }

        function showTelegramOnly() {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('telegram-only').classList.remove('hidden');
        }

        // Функция закрытия WebApp
        function closeApp() {
            tg?.close();
        }

        // Запуск проверки при загрузке
        window.addEventListener('load', checkAccess);
    </script>
</body>
</html>