<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit();
}

// Подключение к базе данных SQLite
$db = new PDO('sqlite:data.db');
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Создание таблицы manager, если не существует
$db->exec("CREATE TABLE IF NOT EXISTS manager (
    user_id INTEGER PRIMARY KEY,
    name TEXT NOT NULL,
    status TEXT DEFAULT 'active'
)");

// Обработка формы создания
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create') {
    $name = trim($_POST['name'] ?? '');
    $user_id = (int)($_POST['user_id'] ?? 0);

    if (!empty($name) && $user_id > 0) {
        // Проверяем, существует ли уже менеджер с таким user_id
        $stmt = $db->prepare("SELECT user_id FROM manager WHERE user_id = ?");
        $stmt->execute([$user_id]);
        if ($stmt->fetch()) {
            $message = 'Ошибка: Менеджер с таким user_id уже существует!';
        } else {
            $stmt = $db->prepare("INSERT INTO manager (user_id, name, status) VALUES (?, ?, 'active')");
            $stmt->execute([$user_id, $name]);
            $message = 'Менеджер успешно создан!';
        }
    } else {
        $message = 'Ошибка: Заполните все поля корректно!';
    }
}

// Обработка удаления
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete') {
    $user_id = (int)($_POST['user_id'] ?? 0);
    if ($user_id > 0) {
        $stmt = $db->prepare("DELETE FROM manager WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $message = 'Менеджер успешно удалён!';
    } else {
        $message = 'Ошибка удаления: Неверный user_id!';
    }
}

// Получение списка менеджеров
$stmt = $db->prepare("SELECT * FROM manager ORDER BY user_id ASC");
$stmt->execute();
$managers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Менеджеры - Админ-панель</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        pastel: {
                            pink: '#fce7f3',
                            blue: '#dbeafe',
                            green: '#dcfce7',
                            yellow: '#fef3c7',
                            purple: '#ede9fe',
                        },
                        gradient: {
                            from: '#f8fafc',
                            to: '#f1f5f9',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        /* Кастомные стили для пастельного градиента и мягких эффектов */
        .pastel-bg {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }
        .card-glass {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .gradient-card {
            background: linear-gradient(135deg, #fef3c7 0%, #dbeafe 100%);
        }
        .hover-lift {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .hover-lift:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .table-row-hover {
            transition: background-color 0.2s ease;
        }
        .table-row-hover:hover {
            background-color: rgba(254, 243, 199, 0.5);
        }
        /* Мобильные стили для таблицы */
        @media (max-width: 768px) {
            .table-container {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
            .table th, .table td {
                min-width: 120px;
                padding: 0.75rem 0.5rem;
                font-size: 0.875rem;
            }
            .btn-mobile {
                padding: 0.5rem 0.75rem;
                font-size: 0.75rem;
            }
        }
    </style>
</head>
<body class="min-h-screen font-sans antialiased pastel-bg">
    <?php include 'admin_sidebar.php'; ?>
    
    <div class="lg:ml-64 p-4 lg:p-8 min-h-screen">
        <!-- Мобильная кнопка меню (toggle) -->
        <button id="menu-toggle" class="lg:hidden fixed top-4 left-4 z-50 p-2 bg-white rounded-xl shadow-md text-gray-600 hover:text-gray-800 transition-colors">
            <span class="text-2xl">☰</span>
        </button>
        
        <!-- Header Card -->
        <div class="card-glass rounded-3xl p-4 lg:p-8 mb-6 lg:mb-8 hover-lift relative">
            <div class="flex justify-between items-center flex-col lg:flex-row lg:gap-4">
                <div class="flex items-center mb-4 lg:mb-0">
                    <div class="w-10 h-10 lg:w-12 lg:h-12 bg-gradient-to-br from-purple-200 to-pink-200 rounded-xl lg:rounded-2xl flex items-center justify-center mr-3 lg:mr-4">
                        <span class="text-lg lg:text-xl">👨‍💼</span>
                    </div>
                    <div>
                        <h1 class="text-2xl lg:text-3xl font-bold text-gray-800">Менеджеры</h1>
                        <p class="text-gray-600 mt-1 text-sm lg:text-base">Управление менеджерами системы</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Форма создания менеджера -->
        <div class="card-glass rounded-3xl p-4 lg:p-8 mb-6 lg:mb-8 hover-lift">
            <h2 class="text-lg lg:text-xl font-semibold text-gray-700 mb-4">Создать менеджера</h2>
            <?php if ($message): ?>
                <div class="mb-4 p-3 rounded-xl <?php echo strpos($message, 'Ошибка') !== false ? 'bg-red-50 border border-red-200 text-red-700' : 'bg-green-50 border border-green-200 text-green-700'; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            <form method="POST" class="space-y-4">
                <input type="hidden" name="action" value="create">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Позывной (имя) менеджера</label>
                    <input type="text" id="name" name="name" required class="w-full px-4 py-2 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-200 focus:border-transparent transition-all" placeholder="Введите позывной">
                </div>
                <div>
                    <label for="user_id" class="block text-sm font-medium text-gray-700 mb-2">User ID менеджера</label>
                    <input type="number" id="user_id" name="user_id" required min="1" class="w-full px-4 py-2 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-200 focus:border-transparent transition-all" placeholder="Введите user_id">
                </div>
                <button type="submit" class="w-full lg:w-auto bg-gradient-to-r from-purple-500 to-pink-500 text-white px-6 py-2 rounded-xl hover-lift focus:outline-none focus:ring-2 focus:ring-purple-200 transition-all font-medium">
                    Сохранить
                </button>
            </form>
        </div>

        <!-- Список менеджеров -->
        <div class="card-glass rounded-3xl overflow-hidden hover-lift table-container">
            <div class="px-4 lg:px-8 py-4 lg:py-6 border-b border-gray-200">
                <h2 class="text-base lg:text-lg font-semibold text-gray-700">Список менеджеров</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full table-auto">
                    <thead class="bg-white/50">
                        <tr>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">User ID</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Позывной</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Статус</th>
                            <th class="px-4 lg:px-8 py-3 text-left text-xs lg:text-sm font-semibold text-gray-700 uppercase tracking-wide">Действия</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php if (empty($managers)): ?>
                            <tr>
                                <td colspan="4" class="px-4 lg:px-8 py-16 text-center text-gray-500">
                                    <div class="flex flex-col items-center">
                                        <div class="text-5xl lg:text-6xl mb-4 opacity-30">👨‍💼</div>
                                        <p class="text-base lg:text-lg font-medium">Менеджеры не найдены</p>
                                        <p class="text-sm mt-1">Создайте первого менеджера выше</p>
                                    </div>
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($managers as $manager): ?>
                                <tr class="table-row-hover">
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <span class="inline-flex px-2 lg:px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo htmlspecialchars($manager['user_id']); ?></span>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <div class="text-xs lg:text-sm font-medium text-gray-900"><?php echo htmlspecialchars($manager['name']); ?></div>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full <?php echo ($manager['status'] === 'active') ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'; ?>">
                                            <?php echo htmlspecialchars($manager['status']); ?>
                                        </span>
                                    </td>
                                    <td class="px-4 lg:px-8 py-3 whitespace-nowrap text-xs lg:text-sm font-medium">
                                        <div class="flex flex-col sm:flex-row space-y-1 sm:space-y-0 sm:space-x-2">
                                            <form method="POST" class="w-full sm:w-auto btn-mobile inline-block">
                                                <input type="hidden" name="action" value="delete">
                                                <input type="hidden" name="user_id" value="<?php echo $manager['user_id']; ?>">
                                                <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center px-3 lg:px-4 py-1.5 lg:py-2 border border-gray-300 text-xs lg:text-sm leading-4 font-medium rounded-lg lg:rounded-xl text-red-700 bg-white hover:bg-red-50 focus:outline-none focus:ring-2 focus:ring-red-200 focus:ring-offset-2 transition-all" onclick="return confirm('Вы уверены, что хотите удалить менеджера <?php echo htmlspecialchars($manager['name']); ?>?')">
                                                    <span class="mr-1">🗑️</span> Удалить
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        // JS для мобильного toggle (из sidebar)
        const menuToggle = document.getElementById('menu-toggle');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        if (menuToggle) {
            menuToggle.addEventListener('click', () => {
                sidebar.classList.toggle('-translate-x-full');
                if (overlay) overlay.classList.toggle('hidden');
            });
        }

        if (overlay) {
            overlay.addEventListener('click', () => {
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            });
        }

        // Закрыть на esc
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') {
                sidebar.classList.add('-translate-x-full');
                if (overlay) overlay.classList.add('hidden');
            }
        });
    </script>
</body>
</html>