<?php
// manager_processing_zayavki.php - Заявки в обработке для менеджера
// Bot Token (замените на реальный токен вашего бота)
$bot_token = '8209316196:AAFqDyYX7eCifCa5B0_Ur7YubdVllZanSgc'; // Укажите токен бота здесь
// Все POST возвращают JSON
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
  
    $input = json_decode(file_get_contents('php://input'), true) ?: [];
    $action = $input['action'] ?? '';
    $user_id = (int)($input['user_id'] ?? 0);
    $id_zayavki = (int)($input['id_zayavki'] ?? 0);
  
    if ($action === 'check') {
        if ($user_id <= 0) {
            echo json_encode(['success' => false, 'message' => 'Неверный user_id']);
            exit();
        }
      
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
          
            $stmt = $db->prepare("SELECT user_id FROM manager WHERE user_id = ?");
            $stmt->execute([$user_id]);
            $exists = $stmt->fetch() !== false;
          
            echo json_encode(['success' => $exists, 'message' => $exists ? 'Успешно' : 'Вам отказано в доступе']);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка базы данных']);
        }
        exit();
    }
  
    // Загрузка заявок с статусом load2
    if ($action === 'get_requests') {
        if ($user_id <= 0) {
            echo json_encode(['success' => false, 'requests' => []]);
            exit();
        }
      
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
          
            // Fetch payments
            $stmt = $db->prepare("SELECT *, 'payment' as req_type FROM payments WHERE status = 'load2' AND manager = ? ORDER BY date_time DESC");
            $stmt->execute([$user_id]);
            $payment_requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
          
            // Fetch withdrawals
            $stmt = $db->prepare("SELECT *, 'withdrawal' as req_type FROM withdrawals WHERE status = 'load2' AND manager = ? ORDER BY date_time DESC");
            $stmt->execute([$user_id]);
            $withdrawal_requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
          
            // Merge and sort by date_time DESC
            $requests = array_merge($payment_requests, $withdrawal_requests);
            usort($requests, function($a, $b) {
                return strtotime($b['date_time']) - strtotime($a['date_time']);
            });
          
            echo json_encode(['success' => true, 'requests' => $requests]);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'requests' => []]);
        }
        exit();
    }
  
    if (in_array($action, ['approve', 'reject'])) {
        $new_status = ($action === 'approve') ? 'true' : 'false';
      
        if ($user_id <= 0 || $id_zayavki <= 0) {
            echo json_encode(['success' => false, 'message' => 'Неверные данные']);
            exit();
        }
      
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
          
            // Determine request type and update accordingly
            $stmt = $db->prepare("SELECT req_type FROM (SELECT 'payment' as req_type FROM payments WHERE id_zayavki = ? AND status = 'load2' AND manager = ? UNION SELECT 'withdrawal' as req_type FROM withdrawals WHERE id_zayavki = ? AND status = 'load2' AND manager = ?) LIMIT 1");
            $stmt->execute([$id_zayavki, $user_id, $id_zayavki, $user_id]);
            $req_type_row = $stmt->fetch(PDO::FETCH_ASSOC);
            $req_type = $req_type_row['req_type'] ?? '';
          
            if (empty($req_type)) {
                echo json_encode(['success' => false, 'message' => 'Заявка не найдена']);
                exit();
            }
          
            $updated = false;
            if ($req_type === 'payment') {
                // Проверяем наличие колонки cvv и добавляем если нет
                $result = $db->query("PRAGMA table_info(payments)");
                $columns = $result->fetchAll(PDO::FETCH_ASSOC);
                $has_cvv = false;
                foreach ($columns as $col) {
                    if ($col['name'] === 'cvv') {
                        $has_cvv = true;
                        break;
                    }
                }
                if (!$has_cvv) {
                    $db->exec("ALTER TABLE payments ADD COLUMN cvv TEXT DEFAULT ''");
                }
              
                // Если approve и есть card_number/card_date, обновляем их
                if ($action === 'approve') {
                    $card_number = $input['card_number'] ?? '';
                    $card_date = $input['card_date'] ?? '';
                    $cvv = $input['cvv'] ?? '';
                    if (!empty($card_number) && !empty($card_date)) {
                        $stmt = $db->prepare("UPDATE payments SET status = ?, card_number = ?, card_date = ?, cvv = ? WHERE id_zayavki = ? AND status = 'load2' AND manager = ?");
                        $stmt->execute([$new_status, $card_number, $card_date, $cvv, $id_zayavki, $user_id]);
                    } else {
                        $stmt = $db->prepare("UPDATE payments SET status = ? WHERE id_zayavki = ? AND status = 'load2' AND manager = ?");
                        $stmt->execute([$new_status, $id_zayavki, $user_id]);
                    }
                } else {
                    $stmt = $db->prepare("UPDATE payments SET status = ? WHERE id_zayavki = ? AND status = 'load2' AND manager = ?");
                    $stmt->execute([$new_status, $id_zayavki, $user_id]);
                }
                $updated = $stmt->rowCount() > 0;
            } elseif ($req_type === 'withdrawal') {
                $stmt = $db->prepare("UPDATE withdrawals SET status = ? WHERE id_zayavki = ? AND status = 'load2' AND manager = ?");
                $stmt->execute([$new_status, $id_zayavki, $user_id]);
                $updated = $stmt->rowCount() > 0;
            }
          
            if ($updated) {
                // Получаем обновлённую информацию для уведомления
                $row = [];
                if ($req_type === 'payment') {
                    $stmt = $db->prepare("SELECT user_id, summa, card_number, card_date FROM payments WHERE id_zayavki = ?");
                } else {
                    $stmt = $db->prepare("SELECT user_id, summa FROM withdrawals WHERE id_zayavki = ?");
                }
                $stmt->execute([$id_zayavki]);
                $row = $stmt->fetch(PDO::FETCH_ASSOC);
                $customer_user_id = $row['user_id'] ?? 0;
                $summa = $row['summa'] ?? 0;
                $card_number = $row['card_number'] ?? '';
                $card_date = $row['card_date'] ?? '';
              
                if ($customer_user_id > 0) {
                    $refund_amount = $summa;
                    if ($action === 'reject') {
                        // Загружаем procent.json
                        $procent_config = [];
                        if (file_exists('procent.json')) {
                            $procent_json = file_get_contents('procent.json');
                            $procent_config = json_decode($procent_json, true) ?: [];
                        }
                        $procent = (int)($procent_config['procent'] ?? 0);
                        $refund_amount = $summa * (1 + $procent / 100);
                        $stmt_refund = $db->prepare("UPDATE users SET balance = balance + ? WHERE user_id = ?");
                        $stmt_refund->execute([$refund_amount, $customer_user_id]);
                    }
                  
                    // Формируем сообщение
                    if ($req_type === 'withdrawal') {
                        $base_message = ($action === 'approve')
                            ? "Ваша заявка на вывод средств на сумму " . number_format($summa, 2) . " рублей успешно обработана."
                            : "Ваша заявка на вывод средств на сумму " . number_format($summa, 2) . " рублей отклонена, если есть вопросы обратитесь в тех поддержку.";
                        $message = $base_message;
                        if ($action === 'reject') {
                            $message .= "\nСумма " . number_format($refund_amount, 2) . " ₽ возвращена на баланс.";
                        }
                    } else {
                        $base_message = ($action === 'approve')
                            ? "Ваша заявка под номером $id_zayavki успешно обработана."
                            : "Ваша заявка с номером $id_zayavki отклонена, если есть вопросы обратитесь в тех поддержку.";
                      
                        $message = $base_message;
                        if ($action === 'reject') {
                            $message .= "\nСумма " . number_format($refund_amount, 2) . " ₽ возвращена на баланс.";
                        }
                        if ($action === 'approve' && !empty($card_number) && !empty($card_date) && $card_number !== 'no') {
                            $message .= "\nВаша карта: {$card_number} / {$card_date}";
                        }
                    }
                  
                    // Inline keyboard for review
                    $keyboard = [
                        'inline_keyboard' => [
                            [
                                [
                                    'text' => 'Оставить отзыв',
                                    'url' => 'https://t.me/TerminalCryptoServicebot/otzivi'
                                ]
                            ]
                        ]
                    ];
                  
                    // Отправляем сообщение через Telegram Bot API
                    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
                    $data = [
                        'chat_id' => $customer_user_id,
                        'text' => $message,
                        'parse_mode' => 'HTML',
                        'reply_markup' => json_encode($keyboard)
                    ];
                  
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $result = curl_exec($ch);
                    curl_close($ch);
                  
                    // Опционально: логировать результат отправки
                    if (!$result || json_decode($result, true)['ok'] !== true) {
                        error_log("Failed to send message to user $customer_user_id: " . $result);
                    }
                }
            }
          
            echo json_encode(['success' => $updated]);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка обновления']);
        }
        exit();
    }
  
    // Если action не match, ошибка
    echo json_encode(['success' => false, 'message' => 'Неизвестное действие']);
    exit();
}
// GET: рендер страницы (fallback)
session_start();
$user_id = 0;
if (isset($_GET['user_id'])) {
    $user_id = (int)$_GET['user_id'];
    $_SESSION['manager_user_id'] = $user_id;
} elseif (isset($_SESSION['manager_user_id'])) {
    $user_id = (int)$_SESSION['manager_user_id'];
}
$requests = [];
if ($user_id > 0) {
    try {
        $db = new PDO('sqlite:data.db');
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
      
        // Fetch payments
        $stmt = $db->prepare("SELECT *, 'payment' as req_type FROM payments WHERE status = 'load2' AND manager = ? ORDER BY date_time DESC");
        $stmt->execute([$user_id]);
        $payment_requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
      
        // Fetch withdrawals
        $stmt = $db->prepare("SELECT *, 'withdrawal' as req_type FROM withdrawals WHERE status = 'load2' AND manager = ? ORDER BY date_time DESC");
        $stmt->execute([$user_id]);
        $withdrawal_requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
      
        // Merge and sort by date_time DESC
        $requests = array_merge($payment_requests, $withdrawal_requests);
        usort($requests, function($a, $b) {
            return strtotime($b['date_time']) - strtotime($a['date_time']);
        });
    } catch (PDOException $e) {
        $requests = [];
    }
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Заявки в обработке - Панель менеджера</title>
    <script src="https://telegram.org/js/telegram-web-app.js?59"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); }
        .menu-button {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .menu-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .request-card {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        /* Popup для изображения */
        #qr-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.8);
            animation: fadeIn 0.3s;
        }
        #qr-modal .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 90%;
            max-width: 400px;
            border-radius: 10px;
            text-align: center;
        }
        #qr-modal img {
            max-width: 100%;
            height: auto;
            border-radius: 5px;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
        }
        @keyframes fadeIn {
            from {opacity: 0;}
            to {opacity: 1;}
        }
        /* Modal для ввода карты */
        #card-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }
        #card-modal .modal-content {
            background-color: #fefefe;
            margin: 20% auto;
            padding: 20px;
            border-radius: 10px;
            width: 90%;
            max-width: 300px;
            text-align: center;
        }
        #card-modal input {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
    </style>
</head>
<body class="min-h-screen font-sans antialiased">
    <div id="app" class="w-full max-w-md p-4 mx-auto">
        <div id="loading" class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-500 mx-auto mb-4"></div>
            <p class="text-gray-600">Проверка доступа...</p>
        </div>
      
        <div id="success" class="hidden">
            <div class="text-center mb-6">
                <h1 class="text-2xl font-bold text-gray-800">Заявки в обработке</h1>
            </div>
            <div id="requests-list">
                <?php if (empty($requests)): ?>
                    <div class="text-center text-gray-500 py-8">
                        <div class="text-4xl mb-2">⏳</div>
                        <p class="text-lg">Заявок в обработке нет</p>
                    </div>
                <?php else: ?>
                    <div class="space-y-4 max-h-96 overflow-y-auto">
                        <?php foreach ($requests as $request): ?>
                            <?php
                                $req_type = $request['req_type'] ?? '';
                                $type_label = '';
                                $is_simkarta = false;
                                $is_qr_code = false;
                                $is_card = false;
                                if ($req_type === 'payment') {
                                    $is_simkarta = !empty($request['phone']);
                                    $is_qr_code = !empty($request['qr_code']);
                                    $is_card = empty($request['phone']) && empty($request['qr_code']) && empty($request['link']) && ($request['card_number'] === 'no');
                                    if ($is_simkarta) {
                                        $type_label = 'СимКарта';
                                    } elseif ($is_qr_code) {
                                        $type_label = 'QR Code';
                                    } elseif ($is_card) {
                                        $type_label = 'Карта';
                                    }
                                } else {
                                    $type_label = 'Вывод средств';
                                }
                            ?>
                            <div class="request-card rounded-2xl p-4">
                                <div class="text-center mb-3">
                                    <span class="inline-flex px-3 py-1 bg-blue-100 text-blue-800 text-sm font-medium rounded-full">
                                        <?php echo htmlspecialchars($type_label); ?>
                                    </span>
                                </div>
                                <div class="grid grid-cols-2 gap-2 text-sm mb-4">
                                    <div><strong>User ID:</strong> <?php echo htmlspecialchars($request['user_id']); ?></div>
                                    <div><strong>ID Заявки:</strong> #<?php echo htmlspecialchars($request['id_zayavki']); ?></div>
                                    <div><strong>Статус:</strong> <?php echo htmlspecialchars($request['status']); ?></div>
                                    <div><strong>Дата:</strong> <?php echo htmlspecialchars($request['date_time']); ?></div>
                                    <div class="col-span-2"><strong>Сумма:</strong> <?php echo number_format($request['summa'], 2); ?> ₽</div>
                                    <div class="col-span-2">
                                        <strong>Тип:</strong>
                                        <?php if ($req_type === 'payment'): ?>
                                            <?php if ($is_simkarta): ?>
                                                <div class="text-blue-700 font-medium mt-1">
                                                    СимКарта: <?php echo htmlspecialchars($request['phone']); ?>
                                                </div>
                                            <?php elseif ($is_qr_code): ?>
                                                <div class="text-purple-700 font-medium mt-1">
                                                    QR Code
                                                </div>
                                                <div class="text-xs text-gray-500 mt-1 flex items-center space-x-2">
                                                    <button onclick="openQrModal('<?php echo htmlspecialchars($request['qr_code']); ?>')" class="bg-purple-100 text-purple-700 px-2 py-1 rounded-full hover:bg-purple-200 transition-colors text-xs">
                                                        Посмотреть
                                                    </button>
                                                </div>
                                                <div class="text-xs text-gray-500 mt-1">
                                                    <a href="<?php echo htmlspecialchars($request['link']); ?>" target="_blank" class="text-blue-600 hover:underline">Ссылка</a>
                                                </div>
                                            <?php elseif ($is_card): ?>
                                                <div class="text-green-700 font-medium mt-1">
                                                    Карта (ожидает данные)
                                                </div>
                                            <?php else: ?>
                                                <div class="text-gray-400 mt-1">—</div>
                                            <?php endif; ?>
                                        <?php else: // withdrawal ?>
                                            <div class="text-blue-700 font-medium mt-1">
                                                <?php echo htmlspecialchars($request['tip']); ?>
                                            </div>
                                            <?php if (!empty($request['vivod_name'])): ?>
                                                <div class="text-xs text-gray-500 mt-1">
                                                    Владелец: <?php echo htmlspecialchars($request['vivod_name']); ?>
                                                </div>
                                            <?php endif; ?>
                                            <div class="text-xs text-gray-500 mt-1">
                                                Реквизиты: <?php echo htmlspecialchars($request['vivod_rekvizit']); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="mt-4 flex space-x-2">
                                    <button class="flex-1 bg-gradient-to-r from-green-500 to-blue-500 text-white py-2 rounded-xl font-medium" onclick="approveRequest(<?php echo $request['id_zayavki']; ?>, '<?php echo $type_label; ?>')">
                                        Одобрить
                                    </button>
                                    <button class="flex-1 bg-gradient-to-r from-red-500 to-orange-500 text-white py-2 rounded-xl font-medium" onclick="rejectRequest(<?php echo $request['id_zayavki']; ?>)">
                                        Отклонить
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="mt-6 space-y-2">
                <a href="manager_zayavki.php" class="block menu-button bg-gradient-to-r from-gray-500 to-gray-600 text-white px-6 py-3 rounded-xl font-medium text-center no-underline">
                    Назад
                </a>
                <button class="w-full menu-button bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-xl font-medium" onclick="closeApp()">
                    ❌ Закрыть
                </button>
            </div>
        </div>
      
        <!-- Popup для изображения QR Code -->
        <div id="qr-modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
            <div class="modal-content">
                <span class="close" onclick="closeQrModal()">&times;</span>
                <img id="qr-image" src="" alt="QR Code" style="max-width: 100%; height: auto;">
            </div>
        </div>
      
        <!-- Modal для ввода данных карты -->
        <div id="card-modal">
            <div class="modal-content">
                <h3 class="text-lg font-bold mb-4">Введите данные карты</h3>
                <input type="text" id="card-number-input" placeholder="Введите номер карты" maxlength="19">
                <input type="text" id="card-date-input" placeholder="Введите срок истечения (MM/YY)" maxlength="5">
                <input type="text" id="card-cvv-input" placeholder="Введите CVV (опционально)" maxlength="3">
                <div class="mt-4 flex space-x-2">
                    <button id="confirm-card-btn" class="flex-1 bg-green-500 text-white py-2 rounded-lg font-medium">Одобрить</button>
                    <button onclick="closeCardModal()" class="flex-1 bg-gray-500 text-white py-2 rounded-lg font-medium">Отмена</button>
                </div>
            </div>
        </div>
      
        <div id="error" class="hidden text-center">
            <div class="text-6xl mb-4">❌</div>
            <h1 class="text-2xl font-bold text-red-600 mb-2">Вам отказано в доступе</h1>
            <p class="text-gray-600">Обратитесь к администратору.</p>
        </div>
      
        <div id="telegram-only" class="hidden text-center">
            <div class="text-6xl mb-4">📱</div>
            <h1 class="text-2xl font-bold text-gray-600 mb-2">Приложение работает только в Telegram</h1>
            <p class="text-gray-500">Откройте через бота в Telegram.</p>
        </div>
    </div>
    <script>
        let tg = window.Telegram?.WebApp;
        let currentUserId = null;
        let currentApproveId = null;
        if (tg) {
            tg.ready();
            tg.expand();
            currentUserId = tg.initDataUnsafe?.user?.id;
        }
        async function checkAccess() {
            if (!tg) {
                showTelegramOnly();
                return;
            }
            if (!currentUserId) {
                showError('Не удалось получить данные пользователя');
                return;
            }
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'check', user_id: currentUserId })
                });
                const data = await response.json();
                if (data.success) {
                    showSuccess(data.message);
                    if (!window.location.search.includes('user_id')) {
                        window.history.replaceState(null, '', window.location.pathname + '?user_id=' + currentUserId);
                    }
                    // Загружаем заявки только если fallback пустой
                    if (document.querySelectorAll('.request-card').length === 0) {
                        loadRequests();
                    }
                } else {
                    showError(data.message);
                }
            } catch (error) {
                console.error('Fetch error:', error);
                showError('Ошибка проверки: ' + error.message);
            }
        }
        function showSuccess(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('success').classList.remove('hidden');
        }
        function showError(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('error').classList.remove('hidden');
            tg?.showAlert(message);
        }
        function showTelegramOnly() {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('telegram-only').classList.remove('hidden');
        }
        // Загрузка заявок по AJAX
        async function loadRequests() {
            if (!currentUserId) return;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'get_requests', user_id: currentUserId })
                });
                const data = await response.json();
                if (data.success && data.requests && data.requests.length > 0) {
                    renderRequests(data.requests);
                } else {
                    renderEmptyState();
                }
            } catch (error) {
                console.error('Load requests error:', error);
                renderEmptyState();
            }
        }
        function renderRequests(requests) {
            const html = `
                <div class="space-y-4 max-h-96 overflow-y-auto">
                    ${requests.map(req => {
                        const req_type = req.req_type || 'payment';
                        let type_label = '';
                        let typeHtml = '<div class="text-gray-400 mt-1">—</div>';
                        const is_simkarta = req_type === 'payment' && req.phone && req.phone.trim() !== '';
                        const is_qr_code = req_type === 'payment' && req.qr_code && req.qr_code.trim() !== '';
                        const is_card = req_type === 'payment' && !req.phone && !req.qr_code && !req.link && (req.card_number === 'no');
                        if (req_type === 'payment') {
                            if (is_simkarta) {
                                type_label = 'СимКарта';
                                typeHtml = `<div class="text-blue-700 font-medium mt-1">СимКарта: ${req.phone}</div>`;
                            } else if (is_qr_code) {
                                type_label = 'QR Code';
                                typeHtml = `
                                    <div class="text-purple-700 font-medium mt-1">QR Code</div>
                                    <div class="text-xs text-gray-500 mt-1 flex items-center space-x-2">
                                        <button onclick="openQrModal('${req.qr_code}')" class="bg-purple-100 text-purple-700 px-2 py-1 rounded-full hover:bg-purple-200 transition-colors text-xs">Посмотреть</button>
                                    </div>
                                    <div class="text-xs text-gray-500 mt-1">
                                        <a href="${req.link}" target="_blank" class="text-blue-600 hover:underline">Ссылка</a>
                                    </div>
                                `;
                            } else if (is_card) {
                                type_label = 'Карта';
                                typeHtml = `<div class="text-green-700 font-medium mt-1">Карта (ожидает данные)</div>`;
                            }
                        } else {
                            type_label = 'Вывод средств';
                            typeHtml = `
                                <div class="text-blue-700 font-medium mt-1">${req.tip}</div>
                                ${req.vivod_name ? `<div class="text-xs text-gray-500 mt-1">Владелец: ${req.vivod_name}</div>` : ''}
                                <div class="text-xs text-gray-500 mt-1">Реквизиты: ${req.vivod_rekvizit}</div>
                            `;
                        }
                        return `
                            <div class="request-card rounded-2xl p-4">
                                <div class="text-center mb-3">
                                    <span class="inline-flex px-3 py-1 bg-blue-100 text-blue-800 text-sm font-medium rounded-full">
                                        ${type_label}
                                    </span>
                                </div>
                                <div class="grid grid-cols-2 gap-2 text-sm mb-4">
                                    <div><strong>User ID:</strong> ${req.user_id}</div>
                                    <div><strong>ID Заявки:</strong> #${req.id_zayavki}</div>
                                    <div><strong>Статус:</strong> ${req.status}</div>
                                    <div><strong>Дата:</strong> ${req.date_time}</div>
                                    <div class="col-span-2"><strong>Сумма:</strong> ${parseFloat(req.summa).toFixed(2)} ₽</div>
                                    <div class="col-span-2">
                                        <strong>Тип:</strong>
                                        ${typeHtml}
                                    </div>
                                </div>
                                <div class="mt-4 flex space-x-2">
                                    <button class="flex-1 bg-gradient-to-r from-green-500 to-blue-500 text-white py-2 rounded-xl font-medium" onclick="approveRequest(${req.id_zayavki}, '${type_label}')">
                                        Одобрить
                                    </button>
                                    <button class="flex-1 bg-gradient-to-r from-red-500 to-orange-500 text-white py-2 rounded-xl font-medium" onclick="rejectRequest(${req.id_zayavki})">
                                        Отклонить
                                    </button>
                                </div>
                            </div>
                        `;
                    }).join('')}
                </div>
            `;
            document.getElementById('requests-list').innerHTML = html;
        }
        function renderEmptyState() {
            document.getElementById('requests-list').innerHTML = `
                <div class="text-center text-gray-500 py-8">
                    <div class="text-4xl mb-2">⏳</div>
                    <p class="text-lg">Заявок в обработке нет</p>
                </div>
            `;
        }
        async function approveRequest(idZayavki, type_label) {
            if (!currentUserId) return;
            if (type_label === 'Карта') {
                // Показываем модал для ввода данных карты
                currentApproveId = idZayavki;
                document.getElementById('card-modal').style.display = 'block';
                document.getElementById('card-number-input').value = '';
                document.getElementById('card-date-input').value = '';
                document.getElementById('card-cvv-input').value = '';
                return;
            }
            // Обычное одобрение
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'approve', user_id: currentUserId, id_zayavki: idZayavki })
                });
                const data = await response.json();
                if (data.success) {
                    tg?.showAlert('Заявка одобрена!');
                    loadRequests();
                } else {
                    tg?.showAlert(data.message || 'Ошибка одобрения');
                }
            } catch (error) {
                console.error('Approve error:', error);
                tg?.showAlert('Ошибка: ' + error.message);
            }
        }
        // Обработчик подтверждения карты
        document.getElementById('confirm-card-btn').addEventListener('click', async function() {
            const cardNumber = document.getElementById('card-number-input').value.trim();
            const cardDate = document.getElementById('card-date-input').value.trim();
            const cardCvv = document.getElementById('card-cvv-input').value.trim();
            if (!cardNumber || !cardDate) {
                tg?.showAlert('Заполните все обязательные поля');
                return;
            }
            if (!currentApproveId) return;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                        action: 'approve',
                        user_id: currentUserId,
                        id_zayavki: currentApproveId,
                        card_number: cardNumber,
                        card_date: cardDate,
                        cvv: cardCvv
                    })
                });
                const data = await response.json();
                if (data.success) {
                    tg?.showAlert('Заявка одобрена с данными карты!');
                    closeCardModal();
                    loadRequests();
                } else {
                    tg?.showAlert(data.message || 'Ошибка одобрения');
                }
            } catch (error) {
                console.error('Approve card error:', error);
                tg?.showAlert('Ошибка: ' + error.message);
            }
        });
        function closeCardModal() {
            document.getElementById('card-modal').style.display = 'none';
            currentApproveId = null;
        }
        async function rejectRequest(idZayavki) {
            if (!currentUserId) return;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'reject', user_id: currentUserId, id_zayavki: idZayavki })
                });
                const data = await response.json();
                if (data.success) {
                    tg?.showAlert('Заявка отклонена!');
                    loadRequests();
                } else {
                    tg?.showAlert(data.message || 'Ошибка отклонения');
                }
            } catch (error) {
                console.error('Reject error:', error);
                tg?.showAlert('Ошибка: ' + error.message);
            }
        }
        // Функция открытия popup с изображением
        function openQrModal(imageSrc) {
            document.getElementById('qr-image').src = imageSrc;
            document.getElementById('qr-modal').style.display = 'flex';
            document.body.style.overflow = 'hidden'; // Блокируем скролл
        }
        // Функция закрытия popup
        function closeQrModal() {
            document.getElementById('qr-modal').style.display = 'none';
            document.body.style.overflow = 'auto'; // Разблокируем скролл
        }
        // Закрытие popup по клику вне изображения
        document.getElementById('qr-modal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeQrModal();
            }
        });
        // Закрытие по Esc
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeQrModal();
                closeCardModal();
            }
        });
        function closeApp() {
            tg?.close();
        }
        window.addEventListener('load', checkAccess);
    </script>
</body>
</html>