<?php
// manager_new_zayavki.php - Новые заявки для менеджера
// Все POST возвращают JSON
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
   
    $input = json_decode(file_get_contents('php://input'), true) ?: [];
    $action = $input['action'] ?? '';
    $user_id = (int)($input['user_id'] ?? 0);
    $id_zayavki = (int)($input['id_zayavki'] ?? 0);
    $req_type = $input['type'] ?? '';
   
    if ($action === 'check') {
        if ($user_id <= 0) {
            echo json_encode(['success' => false, 'message' => 'Неверный user_id']);
            exit();
        }
       
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
           
            $stmt = $db->prepare("SELECT user_id FROM manager WHERE user_id = ?");
            $stmt->execute([$user_id]);
            $exists = $stmt->fetch() !== false;
           
            echo json_encode(['success' => $exists, 'message' => $exists ? 'Успешно' : 'Вам отказано в доступе']);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка базы данных']);
        }
        exit();
    }
   
    if ($action === 'take') {
        if ($user_id <= 0 || $id_zayavki <= 0 || !in_array($req_type, ['payment', 'withdrawal'])) {
            echo json_encode(['success' => false, 'message' => 'Неверные данные']);
            exit();
        }
       
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
           
            if ($req_type === 'payment') {
                $stmt = $db->prepare("UPDATE payments SET status = 'load2', manager = ? WHERE id_zayavki = ? AND status = 'load'");
                $stmt->execute([$user_id, $id_zayavki]);
                $redirect = 'manager_processing_zayavki.php';
            } elseif ($req_type === 'withdrawal') {
                $stmt = $db->prepare("UPDATE withdrawals SET status = 'load2', manager = ? WHERE id_zayavki = ? AND status = 'load'");
                $stmt->execute([$user_id, $id_zayavki]);
                $redirect = 'manager_processing_zayavki.php';
            }
           
            echo json_encode(['success' => $stmt->rowCount() > 0, 'redirect' => $redirect]);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка обновления']);
        }
        exit();
    }
   
    // Если action не match, ошибка
    echo json_encode(['success' => false, 'message' => 'Неизвестное действие']);
    exit();
}
// GET: рендер страницы (fallback, но с проверкой в JS)
session_start();
if (!isset($_SESSION['manager_user_id']) && isset($_GET['user_id'])) {
    $_SESSION['manager_user_id'] = (int)$_GET['user_id'];
}
$requests = [];
try {
    $db = new PDO('sqlite:data.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
   
    // Fetch payments
    $stmt = $db->prepare("SELECT *, 'payment' as type FROM payments WHERE status = 'load' ORDER BY date_time DESC");
    $stmt->execute();
    $payment_requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
   
    // Fetch withdrawals
    $stmt = $db->prepare("SELECT *, 'withdrawal' as type FROM withdrawals WHERE status = 'load' ORDER BY date_time DESC");
    $stmt->execute();
    $withdrawal_requests = $stmt->fetchAll(PDO::FETCH_ASSOC);
   
    // Merge and sort by date_time DESC
    $requests = array_merge($payment_requests, $withdrawal_requests);
    usort($requests, function($a, $b) {
        return strtotime($b['date_time']) - strtotime($a['date_time']);
    });
} catch (PDOException $e) {
    $requests = [];
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Новые заявки - Панель менеджера</title>
    <!-- Telegram WebApp Script -->
    <script src="https://telegram.org/js/telegram-web-app.js?59"></script>
    <!-- Tailwind CSS CDN для стиля -->
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); }
        .menu-button {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .menu-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .request-card {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        /* Popup для изображения */
        #qr-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.8);
            animation: fadeIn 0.3s;
        }
        #qr-modal .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 90%;
            max-width: 400px;
            border-radius: 10px;
            text-align: center;
        }
        #qr-modal img {
            max-width: 100%;
            height: auto;
            border-radius: 5px;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
        }
        @keyframes fadeIn {
            from {opacity: 0;}
            to {opacity: 1;}
        }
    </style>
</head>
<body class="min-h-screen font-sans antialiased">
    <div id="app" class="w-full max-w-md p-4 mx-auto">
        <div id="loading" class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-500 mx-auto mb-4"></div>
            <p class="text-gray-600">Проверка доступа...</p>
        </div>
       
        <div id="success" class="hidden">
            <div class="text-center mb-6">
                <h1 class="text-2xl font-bold text-gray-800">Новые заявки</h1>
            </div>
            <?php if (empty($requests)): ?>
                <div class="text-center text-gray-500 py-8">
                    <div class="text-4xl mb-2">📋</div>
                    <p class="text-lg">Новых заявок нет</p>
                </div>
            <?php else: ?>
                <div class="space-y-4 max-h-96 overflow-y-auto">
                    <?php foreach ($requests as $request): ?>
                        <?php
                            $type_label = '';
                            $is_simkarta = false;
                            $is_qr_code = false;
                            $is_card = false;
                            if ($request['type'] === 'payment') {
                                $is_simkarta = !empty($request['phone']);
                                $is_qr_code = !empty($request['qr_code']);
                                $is_card = empty($request['phone']) && empty($request['qr_code']) && empty($request['link']) && !empty($request['card_number']) && !empty($request['card_date']);
                                if ($is_simkarta) {
                                    $type_label = 'СимКарта';
                                } elseif ($is_qr_code) {
                                    $type_label = 'QR Code';
                                } elseif ($is_card) {
                                    $type_label = 'Карта';
                                }
                            } else { // withdrawal
                                $type_label = 'Вывод средств';
                            }
                            $status_display = ($request['status'] === 'load') ? 'В обработке' : htmlspecialchars($request['status']);
                        ?>
                        <div class="request-card rounded-2xl p-4">
                            <div class="text-center mb-3">
                                <span class="inline-flex px-3 py-1 bg-blue-100 text-blue-800 text-sm font-medium rounded-full">
                                    <?php echo htmlspecialchars($type_label); ?>
                                </span>
                            </div>
                            <div class="grid grid-cols-2 gap-2 text-sm mb-4">
                                <div><strong>User ID:</strong> <?php echo htmlspecialchars($request['user_id']); ?></div>
                                <div><strong>ID Заявки:</strong> #<?php echo htmlspecialchars($request['id_zayavki']); ?></div>
                                <div><strong>Статус:</strong> <?php echo $status_display; ?></div>
                                <div><strong>Дата:</strong> <?php echo htmlspecialchars($request['date_time']); ?></div>
                                <div class="col-span-2"><strong>Сумма:</strong> <?php echo number_format($request['summa'], 2); ?> ₽</div>
                                <div class="col-span-2">
                                    <strong>Тип:</strong>
                                    <?php if ($request['type'] === 'payment'): ?>
                                        <?php if ($is_simkarta): ?>
                                            <div class="text-blue-700 font-medium mt-1">
                                                СимКарта: <?php echo htmlspecialchars($request['phone']); ?>
                                            </div>
                                        <?php elseif ($is_qr_code): ?>
                                            <div class="text-purple-700 font-medium mt-1">
                                                QR Code
                                            </div>
                                            <div class="text-xs text-gray-500 mt-1 flex items-center space-x-2">
                                                <button onclick="openQrModal('<?php echo htmlspecialchars($request['qr_code']); ?>')" class="bg-purple-100 text-purple-700 px-2 py-1 rounded-full hover:bg-purple-200 transition-colors text-xs">
                                                    Посмотреть
                                                </button>
                                            </div>
                                            <div class="text-xs text-gray-500 mt-1">
                                                <a href="<?php echo htmlspecialchars($request['link']); ?>" target="_blank" class="text-blue-600 hover:underline">Ссылка</a>
                                            </div>
                                        <?php elseif ($is_card): ?>
                                            <div class="text-green-700 font-medium mt-1">
                                                Карта: <?php echo htmlspecialchars($request['card_number']); ?> / <?php echo htmlspecialchars($request['card_date']); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-gray-400 mt-1">—</div>
                                        <?php endif; ?>
                                    <?php else: // withdrawal ?>
                                        <div class="text-blue-700 font-medium mt-1">
                                            <?php echo htmlspecialchars($request['tip']); ?>
                                        </div>
                                        <?php if (!empty($request['vivod_name'])): ?>
                                            <div class="text-xs text-gray-500 mt-1">
                                                Владелец: <?php echo htmlspecialchars($request['vivod_name']); ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="text-xs text-gray-500 mt-1">
                                            Реквизиты: <?php echo htmlspecialchars($request['vivod_rekvizit']); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <button class="w-full bg-gradient-to-r from-blue-500 to-green-500 text-white py-2 rounded-xl font-medium" onclick="takeRequest(<?php echo $request['id_zayavki']; ?>, '<?php echo $request['type']; ?>')">
                                Взять в обработку
                            </button>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <div class="mt-6 space-y-2">
                <a href="manager_zayavki.php" class="block menu-button bg-gradient-to-r from-gray-500 to-gray-600 text-white px-6 py-3 rounded-xl font-medium text-center no-underline">
                    Назад
                </a>
                <button class="w-full menu-button bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-xl font-medium" onclick="closeApp()">
                    ❌ Закрыть
                </button>
            </div>
        </div>
       
        <!-- Popup для изображения QR Code -->
        <div id="qr-modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
            <div class="modal-content">
                <span class="close" onclick="closeQrModal()">&times;</span>
                <img id="qr-image" src="" alt="QR Code" style="max-width: 100%; height: auto;">
            </div>
        </div>
       
        <div id="error" class="hidden text-center">
            <div class="text-6xl mb-4">❌</div>
            <h1 class="text-2xl font-bold text-red-600 mb-2">Вам отказано в доступе</h1>
            <p class="text-gray-600">Обратитесь к администратору.</p>
        </div>
       
        <div id="telegram-only" class="hidden text-center">
            <div class="text-6xl mb-4">📱</div>
            <h1 class="text-2xl font-bold text-gray-600 mb-2">Приложение работает только в Telegram</h1>
            <p class="text-gray-500">Откройте через бота в Telegram.</p>
        </div>
    </div>
    <script>
        let tg = window.Telegram?.WebApp;
        let currentUserId = null;
        if (tg) {
            tg.ready();
            tg.expand();
            currentUserId = tg.initDataUnsafe?.user?.id;
        }
        // Функция проверки доступа
        async function checkAccess() {
            if (!tg) {
                showTelegramOnly();
                return;
            }
            if (!currentUserId) {
                showError('Не удалось получить данные пользователя');
                return;
            }
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'check', user_id: currentUserId })
                });
                const data = await response.json();
                if (data.success) {
                    showSuccess(data.message);
                    if (!window.location.search.includes('user_id')) {
                        window.history.replaceState(null, '', window.location.pathname + '?user_id=' + currentUserId);
                    }
                } else {
                    showError(data.message);
                }
            } catch (error) {
                console.error('Fetch error:', error); // Для отладки
                showError('Ошибка проверки: ' + error.message);
            }
        }
        function showSuccess(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('success').classList.remove('hidden');
        }
        function showError(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('error').classList.remove('hidden');
            tg?.showAlert(message);
        }
        function showTelegramOnly() {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('telegram-only').classList.remove('hidden');
        }
        // Функция взятия заявки
        async function takeRequest(idZayavki, requestType) {
            if (!currentUserId) return;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'take', user_id: currentUserId, id_zayavki: idZayavki, type: requestType })
                });
                const data = await response.json();
                if (data.success && data.redirect) {
                    window.location.href = data.redirect; // Открытие в той же вкладке
                } else {
                    tg?.showAlert(data.message || 'Ошибка при взятии заявки');
                }
            } catch (error) {
                console.error('Take error:', error);
                tg?.showAlert('Ошибка: ' + error.message);
            }
        }
        // Функция открытия popup с изображением
        function openQrModal(imageSrc) {
            document.getElementById('qr-image').src = imageSrc;
            document.getElementById('qr-modal').style.display = 'flex';
            document.body.style.overflow = 'hidden'; // Блокируем скролл
        }
        // Функция закрытия popup
        function closeQrModal() {
            document.getElementById('qr-modal').style.display = 'none';
            document.body.style.overflow = 'auto'; // Разблокируем скролл
        }
        // Закрытие popup по клику вне изображения
        document.getElementById('qr-modal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeQrModal();
            }
        });
        // Закрытие по Esc
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeQrModal();
            }
        });
        // Функция закрытия WebApp
        function closeApp() {
            tg?.close();
        }
        // Запуск проверки при загрузке
        window.addEventListener('load', checkAccess);
    </script>
</body>
</html>