<?php
// manager_my_cards.php - Мои карты для менеджера
// Обработка POST-запроса
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
   
    $input = json_decode(file_get_contents('php://input'), true) ?: [];
    $action = $input['action'] ?? '';
    $user_id = (int)($input['user_id'] ?? 0);
    $id_zayavki = (int)($input['id_zayavki'] ?? 0);
   
    if ($action === 'check') {
        if ($user_id <= 0) {
            echo json_encode(['success' => false, 'message' => 'Неверный user_id']);
            exit();
        }
       
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
           
            $stmt = $db->prepare("SELECT user_id FROM manager WHERE user_id = ?");
            $stmt->execute([$user_id]);
            $exists = $stmt->fetch() !== false;
           
            echo json_encode(['success' => $exists, 'message' => $exists ? 'Успешно' : 'Вам отказано в доступе']);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка базы данных']);
        }
        exit();
    }
   
    // Загрузка карт менеджера
    if ($action === 'get_cards') {
        if ($user_id <= 0) {
            echo json_encode(['success' => false, 'cards' => []]);
            exit();
        }
       
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
           
            $stmt = $db->prepare("SELECT * FROM payments WHERE manager = ? AND card_number != 'no' AND status != 'complete' ORDER BY date_time DESC");
            $stmt->execute([$user_id]);
            $cards = $stmt->fetchAll(PDO::FETCH_ASSOC);
           
            echo json_encode(['success' => true, 'cards' => $cards]);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'cards' => []]);
        }
        exit();
    }
   
    // Отключение карты
    if ($action === 'disable') {
        if ($user_id <= 0 || $id_zayavki <= 0) {
            echo json_encode(['success' => false, 'message' => 'Неверные данные']);
            exit();
        }
       
        try {
            $db = new PDO('sqlite:data.db');
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
           
            $stmt = $db->prepare("UPDATE payments SET status = 'complete' WHERE id_zayavki = ? AND manager = ? AND status != 'complete'");
            $stmt->execute([$id_zayavki, $user_id]);
           
            $updated = $stmt->rowCount() > 0;
           
            echo json_encode(['success' => $updated]);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Ошибка обновления']);
        }
        exit();
    }
   
    // Если action не match, ошибка
    echo json_encode(['success' => false, 'message' => 'Неизвестное действие']);
    exit();
}
// GET: рендер страницы (fallback)
session_start();
$user_id = 0;
if (isset($_GET['user_id'])) {
    $user_id = (int)$_GET['user_id'];
    $_SESSION['manager_user_id'] = $user_id;
} elseif (isset($_SESSION['manager_user_id'])) {
    $user_id = (int)$_SESSION['manager_user_id'];
}
$cards = [];
if ($user_id > 0) {
    try {
        $db = new PDO('sqlite:data.db');
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
       
        $stmt = $db->prepare("SELECT * FROM payments WHERE manager = ? AND card_number != 'no' AND status != 'complete' ORDER BY date_time DESC");
        $stmt->execute([$user_id]);
        $cards = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $cards = [];
    }
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Мои карты - Панель менеджера</title>
    <script src="https://telegram.org/js/telegram-web-app.js?59"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); }
        .menu-button {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .menu-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .card-item {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
    </style>
</head>
<body class="min-h-screen font-sans antialiased">
    <div id="app" class="w-full max-w-md p-4 mx-auto">
        <div id="loading" class="text-center">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-500 mx-auto mb-4"></div>
            <p class="text-gray-600">Проверка доступа...</p>
        </div>
       
        <div id="success" class="hidden">
            <div class="text-center mb-6">
                <h1 class="text-2xl font-bold text-gray-800">Мои карты</h1>
            </div>
            <div id="cards-list">
                <?php if (empty($cards)): ?>
                    <div class="text-center text-gray-500 py-8">
                        <div class="text-4xl mb-2">💳</div>
                        <p class="text-lg">Выданных карт нет</p>
                    </div>
                <?php else: ?>
                    <div class="space-y-4 max-h-96 overflow-y-auto">
                        <?php foreach ($cards as $card): ?>
                            <div class="card-item rounded-2xl p-4">
                                <div class="grid grid-cols-2 gap-2 text-sm mb-4">
                                    <div><strong>User ID:</strong> <?php echo htmlspecialchars($card['user_id']); ?></div>
                                    <div><strong>ID Заявки:</strong> #<?php echo htmlspecialchars($card['id_zayavki']); ?></div>
                                    <div><strong>Карта:</strong> <?php echo htmlspecialchars($card['card_number']); ?></div>
                                    <div><strong>Срок:</strong> <?php echo htmlspecialchars($card['card_date']); ?></div>
                                    <div><strong>Сумма:</strong> <?php echo number_format($card['summa'], 2); ?> ₽</div>
                                    <div><strong>Дата:</strong> <?php echo htmlspecialchars($card['date_time']); ?></div>
                                    <?php if (!empty($card['cvv'])): ?>
                                        <div class="col-span-2"><strong>CVV:</strong> <?php echo htmlspecialchars($card['cvv']); ?></div>
                                    <?php endif; ?>
                                </div>
                                <div class="mt-4">
                                    <button class="w-full bg-gradient-to-r from-red-500 to-orange-500 text-white py-2 rounded-xl font-medium" onclick="disableCard(<?php echo $card['id_zayavki']; ?>)">
                                        Отключить
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="mt-6 space-y-2">
                <a href="manager_zayavki.php" class="block menu-button bg-gradient-to-r from-gray-500 to-gray-600 text-white px-6 py-3 rounded-xl font-medium text-center no-underline">
                    Назад
                </a>
                <button class="w-full menu-button bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-xl font-medium" onclick="closeApp()">
                    ❌ Закрыть
                </button>
            </div>
        </div>
       
        <div id="error" class="hidden text-center">
            <div class="text-6xl mb-4">❌</div>
            <h1 class="text-2xl font-bold text-red-600 mb-2">Вам отказано в доступе</h1>
            <p class="text-gray-600">Обратитесь к администратору.</p>
        </div>
       
        <div id="telegram-only" class="hidden text-center">
            <div class="text-6xl mb-4">📱</div>
            <h1 class="text-2xl font-bold text-gray-600 mb-2">Приложение работает только в Telegram</h1>
            <p class="text-gray-500">Откройте через бота в Telegram.</p>
        </div>
    </div>
    <script>
        let tg = window.Telegram?.WebApp;
        let currentUserId = null;
        if (tg) {
            tg.ready();
            tg.expand();
            currentUserId = tg.initDataUnsafe?.user?.id;
        }
        async function checkAccess() {
            if (!tg) {
                showTelegramOnly();
                return;
            }
            if (!currentUserId) {
                showError('Не удалось получить данные пользователя');
                return;
            }
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'check', user_id: currentUserId })
                });
                const data = await response.json();
                if (data.success) {
                    showSuccess(data.message);
                    if (document.querySelectorAll('.card-item').length === 0) {
                        loadCards();
                    }
                } else {
                    showError(data.message);
                }
            } catch (error) {
                console.error('Fetch error:', error);
                showError('Ошибка проверки: ' + error.message);
            }
        }
        function showSuccess(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('success').classList.remove('hidden');
        }
        function showError(message) {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('error').classList.remove('hidden');
            tg?.showAlert(message);
        }
        function showTelegramOnly() {
            document.getElementById('loading').classList.add('hidden');
            document.getElementById('telegram-only').classList.remove('hidden');
        }
        // Загрузка карт по AJAX
        async function loadCards() {
            if (!currentUserId) return;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'get_cards', user_id: currentUserId })
                });
                const data = await response.json();
                if (data.success && data.cards && data.cards.length > 0) {
                    renderCards(data.cards);
                } else {
                    renderEmptyState();
                }
            } catch (error) {
                console.error('Load cards error:', error);
                renderEmptyState();
            }
        }
        function renderCards(cards) {
            const html = `
                <div class="space-y-4 max-h-96 overflow-y-auto">
                    ${cards.map(card => `
                        <div class="card-item rounded-2xl p-4">
                            <div class="grid grid-cols-2 gap-2 text-sm mb-4">
                                <div><strong>User ID:</strong> ${card.user_id}</div>
                                <div><strong>ID Заявки:</strong> #${card.id_zayavki}</div>
                                <div><strong>Карта:</strong> ${card.card_number}</div>
                                <div><strong>Срок:</strong> ${card.card_date}</div>
                                <div><strong>Сумма:</strong> ${parseFloat(card.summa).toFixed(2)} ₽</div>
                                <div><strong>Дата:</strong> ${card.date_time}</div>
                                ${card.cvv ? `<div class="col-span-2"><strong>CVV:</strong> ${card.cvv}</div>` : ''}
                            </div>
                            <div class="mt-4">
                                <button class="w-full bg-gradient-to-r from-red-500 to-orange-500 text-white py-2 rounded-xl font-medium" onclick="disableCard(${card.id_zayavki})">
                                    Отключить
                                </button>
                            </div>
                        </div>
                    `).join('')}
                </div>
            `;
            document.getElementById('cards-list').innerHTML = html;
        }
        function renderEmptyState() {
            document.getElementById('cards-list').innerHTML = `
                <div class="text-center text-gray-500 py-8">
                    <div class="text-4xl mb-2">💳</div>
                    <p class="text-lg">Выданных карт нет</p>
                </div>
            `;
        }
        async function disableCard(idZayavki) {
            if (!currentUserId) return;
            try {
                const response = await fetch('', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action: 'disable', user_id: currentUserId, id_zayavki: idZayavki })
                });
                const data = await response.json();
                if (data.success) {
                    tg?.showAlert('Карта отключена!');
                    loadCards();
                } else {
                    tg?.showAlert(data.message || 'Ошибка отключения');
                }
            } catch (error) {
                console.error('Disable error:', error);
                tg?.showAlert('Ошибка: ' + error.message);
            }
        }
        function closeApp() {
            tg?.close();
        }
        window.addEventListener('load', checkAccess);
    </script>
</body>
</html>