# handlers/get_card.py
from aiogram import Router, F
from aiogram.filters import StateFilter
from aiogram.fsm.context import FSMContext
from aiogram.fsm.state import State, StatesGroup
from aiogram.types import Message, InlineKeyboardMarkup, InlineKeyboardButton
import random
from datetime import datetime
import logging
import json
import os
# Импорты для БД
from db import get_user_balance, update_user_balance, save_payment
# Настройка логирования в файл log.txt
logging.basicConfig(filename='log.txt', level=logging.ERROR, format='%(asctime)s - %(levelname)s - %(message)s')
# Импорт клавиатуры
from keyboard import get_main_menu_keyboard
router = Router()
class GetCardStates(StatesGroup):
    wait_amount = State()
def get_chat_id(key: str):
    """Загрузка chat_id из chats.json"""
    try:
        with open(os.path.join(os.path.dirname(os.path.dirname(__file__)), 'chats.json'), 'r', encoding='utf-8') as f:
            data = json.load(f)
        return data.get(key)
    except Exception as e:
        logging.error(f"Ошибка загрузки chats.json: {str(e)}")
        return None
def get_function_status(key: str):
    """Загрузка статуса функции из function.json"""
    try:
        with open(os.path.join(os.path.dirname(os.path.dirname(__file__)), 'function.json'), 'r', encoding='utf-8') as f:
            data = json.load(f)
        return data.get(key, True)
    except Exception as e:
        logging.error(f"Ошибка загрузки function.json: {str(e)}")
        return True
def get_procent_rate():
    """Загрузка процента комиссии из procent.json"""
    try:
        with open(os.path.join(os.path.dirname(os.path.dirname(__file__)), 'procent.json'), 'r', encoding='utf-8') as f:
            data = json.load(f)
        return data.get('procent', 10) / 100  # Возвращаем как десятичную дробь
    except Exception as e:
        logging.error(f"Ошибка загрузки procent.json: {str(e)}")
        return 0.1  # Дефолт 10%
@router.message(F.text == "🆔 Получить карту")
async def get_card_start(message: Message, state: FSMContext):
    user_id = message.from_user.id
 
    if not get_function_status('bankcard'):
        await message.answer("Проводятся технические работы")
        return
 
    balance = get_user_balance(user_id)
 
    if balance < 110:
        text = "❌ Ваш баланс ниже 110 рублей. Пополните свой баланс для продолжения."
        keyboard = InlineKeyboardMarkup(inline_keyboard=[
            [InlineKeyboardButton(text="💰 Пополнить баланс", callback_data="top_up_balance")],
            [InlineKeyboardButton(text="🔙 Назад", callback_data="back_to_menu")]
        ])
        await message.answer(text, reply_markup=keyboard)
        return
 
    await message.answer("Введите сумму для получения банковской карты:")
    await state.set_state(GetCardStates.wait_amount)
@router.message(StateFilter(GetCardStates.wait_amount))
async def process_amount(message: Message, state: FSMContext):
    try:
        amount = float(message.text)
        if amount <= 0:
            await message.answer("❌ Сумма должна быть положительной. Введите заново:")
            return
    except ValueError:
        await message.answer("❌ Неверный формат. Введите число:")
        return
 
    user_id = message.from_user.id
    balance = get_user_balance(user_id)
 
    # Получаем актуальный процент комиссии
    procent_rate = get_procent_rate()
 
    # Расчёт максимальной суммы: balance / (1 + procent_rate)
    max_amount = balance / (1 + procent_rate)
 
    if amount > max_amount:
        await message.answer(f"❌ Вы можете ввести сумму максимум {max_amount:.2f} рублей (учитывая комиссию {int(procent_rate*100)}%). Введите заново:")
        return
 
    # Генерация ID заявки и datetime
    date_time = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    id_zayavki = random.randint(100000, 999999)
 
    # ПЕРВЫЙ: Сохранение заявки в БД
    # ✅ ПРАВИЛЬНЫЙ ПОРЯДОК ПАРАМЕТРОВ
    try:
        save_payment(
            user_id=user_id,
            id_zayavki=id_zayavki,
            status="load",
            date_time=date_time,
            phone='',
            summa=amount,
            manager='',
            qr_code='',
            link='',
            card_number='no',
            card_date='no'
        )
        logging.info(f"Заявка {id_zayavki} сохранена в БД для карты")
    except Exception as e:
        logging.error(f"Ошибка сохранения карты-заявки в БД: {str(e)}")
        await message.answer("❌ Ошибка при создании заявки. Деньги не списаны. Обратитесь в поддержку.")
        await state.clear()
        return
 
    # ВТОРОЙ: Если БД OK, списываем с баланса
    commission = amount * procent_rate
    total_deduct = amount + commission
    update_user_balance(user_id, -total_deduct)
 
    # Уведомление в Telegram
    try:
        zayavki_chat_id = get_chat_id("zayavki")
        if zayavki_chat_id:
            notification_text = f"Новая заявка Карта\nUser ID: {user_id}\nID заявки: {id_zayavki}\nSumma: {amount}\nDate: {date_time}"
            await message.bot.send_message(chat_id=zayavki_chat_id, text=notification_text)
        else:
            logging.error("Не удалось получить chat_id для zayavki")
    except Exception as e:
        logging.error(f"Ошибка отправки уведомления Карта: {str(e)}")
 
    await message.answer(
        f"✅ Заявка с номером {id_zayavki} успешно создана.\n"
        f"Ожидайте обработку.\n"
        f"Сумма: {amount:.2f} рублей ({commission:.2f} комиссия, итого {total_deduct:.2f})\n"
        f"Новый баланс: {get_user_balance(user_id):.2f} рублей."
    )
 
    # Возврат в главное меню
    keyboard = get_main_menu_keyboard()
    await message.answer("Операция завершена. Главное меню:", reply_markup=keyboard)
 
    await state.clear()