from aiogram import Router, F
from aiogram.filters import StateFilter
from aiogram.types import Message, InlineKeyboardMarkup, InlineKeyboardButton
from aiogram.fsm.context import FSMContext
from aiogram.fsm.state import State, StatesGroup
import json
import os
import logging
router = Router()
class CalcForm(StatesGroup):
    waiting_for_input = State()
@router.message(F.text == "🧮 Калькулятор")
async def open_calculator(message: Message, state: FSMContext):
    """Открыть калькулятор комиссии"""
    await state.set_state(CalcForm.waiting_for_input)
    await message.answer("Введите сумму:")
@router.message(StateFilter(CalcForm.waiting_for_input))
async def process_amount(message: Message, state: FSMContext):
    try:
        amount = float(message.text)
        if amount <= 0:
            await message.answer("Сумма должна быть положительной. Введите заново:")
            return
    except ValueError:
        await message.answer("Неверный формат. Введите число:")
        return
    
    # Загрузка процента из procent.json
    try:
        with open(os.path.join(os.path.dirname(os.path.dirname(__file__)), 'procent.json'), 'r', encoding='utf-8') as f:
            data = json.load(f)
        procent = data.get('procent', 10)
    except Exception as e:
        logging.error(f"Ошибка загрузки procent.json: {str(e)}")
        procent = 10
    
    commission = amount * (procent / 100)
    total = amount + commission
    
    output = f"ваша сумма **{amount:.2f}** рублей\nс учётом комиссии сервиса с вашего баланса будет списано **{total:.2f}** рублей"
    
    await message.answer(output, parse_mode='Markdown')
    
    await state.clear()