import requests
import logging

from config import CRYPTO_PAY_TOKEN  # Импорт токена из config.py

logger = logging.getLogger(__name__)

# Базовый URL API Crypto Pay
CRYPTO_PAY_URL = "https://pay.crypt.bot/api"

def make_crypto_pay_request(method: str, params: dict = None):
    """Универсальная функция для запросов к Crypto Pay API"""
    if params is None:
        params = {}
    headers = {"Crypto-Pay-API-Token": CRYPTO_PAY_TOKEN}
    url = f"{CRYPTO_PAY_URL}/{method}"
    try:
        response = requests.post(url, json=params, headers=headers)
        result = response.json()
        return result
    except Exception as e:
        logger.error(f"Error in {method}: {e}")
        return {"ok": False, "error": {"description": str(e)}}

def get_exchange_rate(asset: str = "USDT", fiat: str = "RUB") -> float:
    """
    Получить актуальный курс обмена между крипто и фиатом от API Crypto Pay.
    """
    try:
        result = make_crypto_pay_request("getExchangeRates")
       
        if result.get("ok"):
            rates = result.get("result", [])
            # Ищем курс USDT -> RUB
            for rate in rates:
                if rate.get("source") == asset and rate.get("target") == fiat:
                    rate_value = float(rate.get("rate", 90))
                    return rate_value
       
        return 90.0
       
    except Exception as e:
        logger.error(f"Error getting exchange rate: {e}")
        return 90.0  # Fallback курс