<?php
// admin_sidebar.php - Фрагмент для включения в другие страницы
// Проверяем сессию
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit();
}
?>
<!-- Tailwind CSS уже подключен в страницах, используем classes -->
<style>
    /* Кастомные стили для пастельного дизайна sidebar */
    .pastel-bg {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    }
    .sidebar-glass {
        background: rgba(255, 255, 255, 0.8);
        backdrop-filter: blur(16px);
        border-right: 1px solid rgba(255, 255, 255, 0.2);
        box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
    }
    .nav-link-pastel {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border-radius: 12px;
        margin: 0.25rem 1rem;
        padding: 0.75rem 1rem;
        color: #64748b;
        font-weight: 500;
    }
    .nav-link-pastel:hover, .nav-link-pastel.active {
        background: linear-gradient(135deg, #fef3c7 0%, #dbeafe 100%);
        color: #1e293b;
        transform: translateX(4px);
        box-shadow: 0 4px 12px rgba(254, 243, 199, 0.3);
    }
    .sidebar-header-pastel {
        background: linear-gradient(135deg, #fef3c7 0%, #dbeafe 100%);
        color: #1e293b;
        font-weight: 600;
        padding: 1.5rem 1rem;
        text-align: center;
        border-bottom: 1px solid rgba(255, 255, 255, 0.2);
    }
    @media (max-width: 1024px) {
        .main-content-responsive {
            margin-left: 0 !important;
        }
    }
</style>
<!-- Мобильное меню: sidebar с toggle -->
<nav id="sidebar" class="fixed inset-y-0 left-0 z-50 w-64 sidebar-glass transform -translate-x-full lg:translate-x-0 transition-transform duration-300 ease-in-out">
    <div class="sidebar-header-pastel">
        <h4 class="text-xl">Админ-панель</h4>
        <p class="text-sm opacity-75 mt-1">Управление</p>
    </div>
    <div class="flex flex-col p-4 space-y-2 overflow-y-auto">
        <a class="nav-link-pastel <?php echo (basename($_SERVER['PHP_SELF']) == 'users.php') ? 'active' : ''; ?>" href="users.php">
            👥 Пользователи
        </a>
        <a class="nav-link-pastel <?php echo (basename($_SERVER['PHP_SELF']) == 'managers.php') ? 'active' : ''; ?>" href="managers.php">
            👨‍💼 Менеджеры
        </a>
        <a class="nav-link-pastel <?php echo (basename($_SERVER['PHP_SELF']) == 'requests.php') ? 'active' : ''; ?>" href="requests.php">
            📋 Заявки
        </a>
        <a class="nav-link-pastel <?php echo (basename($_SERVER['PHP_SELF']) == 'reviews.php') ? 'active' : ''; ?>" href="reviews.php">
            ⭐ Отзывы
        </a>
        <a class="nav-link-pastel <?php echo (basename($_SERVER['PHP_SELF']) == 'settings.php') ? 'active' : ''; ?>" href="settings.php">
            ⚙️ Настройки
        </a>
        <a class="nav-link-pastel" href="logout.php">
            🚪 Выход
        </a>
    </div>
</nav>
<!-- Overlay для мобильного меню -->
<div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden hidden transition-opacity duration-300"></div>
<!-- Кнопка toggle для мобильных (вставьте в header страницы, например в users.php) -->
<!-- Пример: <button id="menu-toggle" class="lg:hidden p-2 ml-4 text-gray-600 hover:text-gray-800"><span class="text-2xl">☰</span></button> -->
<script>
    // JS для мобильного toggle
    const menuToggle = document.getElementById('menu-toggle'); // Предполагаем кнопку в странице
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    if (menuToggle) {
        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('-translate-x-full');
            overlay.classList.toggle('hidden');
        });
    }
    overlay.addEventListener('click', () => {
        sidebar.classList.add('-translate-x-full');
        overlay.classList.add('hidden');
    });
    // Закрыть на esc
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        }
    });
</script>